<?php
/**
 * Imoveis Active Record
 * @author  <your-name-here>
 */
class Imoveis extends TRecord
{
    const TABLENAME = 'imoveis';
    const PRIMARYKEY= 'id';
    const IDPOLICY =  'max'; // {max, serial}
    
    
    private $clientes;
    private $subcategoria;
    private $bairro;
    private $imagenss;

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('titulo');
        parent::addAttribute('valor');
        parent::addAttribute('quartos');
        parent::addAttribute('area');
        parent::addAttribute('descricao');
        parent::addAttribute('suites');
        parent::addAttribute('garagens');
        parent::addAttribute('endereco');
        parent::addAttribute('visualizacoes');
        parent::addAttribute('foto');
        parent::addAttribute('framegooglemaps');
        parent::addAttribute('banheiros');
        parent::addAttribute('areaedificada');
        parent::addAttribute('areaconstruida');
        parent::addAttribute('status');
        parent::addAttribute('pagina');
        parent::addAttribute('latitude');
        parent::addAttribute('longitude');
        parent::addAttribute('opcionais');
        parent::addAttribute('video');
        parent::addAttribute('agente');
        parent::addAttribute('clientes_id');
        parent::addAttribute('subcategoria_id');
        parent::addAttribute('bairro_id');
    }

    
    /**
     * Method set_clientes
     * Sample of usage: $imoveis->clientes = $object;
     * @param $object Instance of Clientes
     */
    public function set_clientes(Clientes $object)
    {
        $this->clientes = $object;
        $this->clientes_id = $object->id;
    }
    
    /**
     * Method get_clientes
     * Sample of usage: $imoveis->clientes->attribute;
     * @returns Clientes instance
     */
    public function get_clientes()
    {
        // loads the associated object
        if (empty($this->clientes))
            $this->clientes = new Clientes($this->clientes_id);
    
        // returns the associated object
        return $this->clientes;
    }
    
    
    /**
     * Method set_subcategoria
     * Sample of usage: $imoveis->subcategoria = $object;
     * @param $object Instance of Subcategoria
     */
    public function set_subcategoria(Subcategoria $object)
    {
        $this->subcategoria = $object;
        $this->subcategoria_id = $object->id;
    }
    
    /**
     * Method get_subcategoria
     * Sample of usage: $imoveis->subcategoria->attribute;
     * @returns Subcategoria instance
     */
    public function get_subcategoria()
    {
        // loads the associated object
        if (empty($this->subcategoria))
            $this->subcategoria = new Subcategoria($this->subcategoria_id);
    
        // returns the associated object
        return $this->subcategoria;
    }
    
    
    /**
     * Method set_bairro
     * Sample of usage: $imoveis->bairro = $object;
     * @param $object Instance of Bairro
     */
    public function set_bairro(Bairro $object)
    {
        $this->bairro = $object;
        $this->bairro_id = $object->id;
    }
    
    /**
     * Method get_bairro
     * Sample of usage: $imoveis->bairro->attribute;
     * @returns Bairro instance
     */
    public function get_bairro()
    {
        // loads the associated object
        if (empty($this->bairro))
            $this->bairro = new Bairro($this->bairro_id);
    
        // returns the associated object
        return $this->bairro;
    }
    
    
    /**
     * Method addImagens
     * Add a Imagens to the Imoveis
     * @param $object Instance of Imagens
     */
    public function addImagens(Imagens $object)
    {
        $this->imagenss[] = $object;
    }
    
    /**
     * Method getImagenss
     * Return the Imoveis' Imagens's
     * @return Collection of Imagens
     */
    public function getImagenss()
    {
        return $this->imagenss;
    }

    
    /**
     * Method getContratos
     */
    public function getContratos()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('imoveis_id', '=', $this->id));
        return Contrato::getObjects( $criteria );
    }
    

    /**
     * Reset aggregates
     */
    public function clearParts()
    {
        $this->imagenss = array();
    }

    /**
     * Load the object and its aggregates
     * @param $id object ID
     */
    public function load($id)
    {
        $this->imagenss = parent::loadComposite('Imagens', 'imoveis_id', $id);
    
        // load the object itself
        return parent::load($id);
    }

    /**
     * Store the object and its aggregates
     */
    public function store()
    {
        // store the object itself
        parent::store();
    
        parent::saveComposite('Imagens', 'imoveis_id', $this->id, $this->imagenss);
    }

    /**
     * Delete the object and its aggregates
     * @param $id object ID
     */
    public function delete($id = NULL)
    {
        $id = isset($id) ? $id : $this->id;
        parent::deleteComposite('Imagens', 'imoveis_id', $id);
    
        // delete the object itself
        parent::delete($id);
    }


}
