<?php
/**
 * Contrato Active Record
 * @author  <your-name-here>
 */
class Contrato extends TRecord
{
    const TABLENAME = 'contrato';
    const PRIMARYKEY= 'id';
    const IDPOLICY =  'max'; // {max, serial}
    
    
    private $imoveis;

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('nome');
        parent::addAttribute('contrato');
        parent::addAttribute('imoveis_id');
    }

    
    /**
     * Method set_imoveis
     * Sample of usage: $contrato->imoveis = $object;
     * @param $object Instance of Imoveis
     */
    public function set_imoveis(Imoveis $object)
    {
        $this->imoveis = $object;
        $this->imoveis_id = $object->id;
    }
    
    /**
     * Method get_imoveis
     * Sample of usage: $contrato->imoveis->attribute;
     * @returns Imoveis instance
     */
    public function get_imoveis()
    {
        // loads the associated object
        if (empty($this->imoveis))
            $this->imoveis = new Imoveis($this->imoveis_id);
    
        // returns the associated object
        return $this->imoveis;
    }
    


}
