<?php
/**
 * Cidades Active Record
 * @author  <your-name-here>
 */
class Cidades extends TRecord
{
    const TABLENAME = 'cidades';
    const PRIMARYKEY= 'id';
    const IDPOLICY =  'max'; // {max, serial}
    
    
    private $estados;

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('uf');
        parent::addAttribute('nome');
        parent::addAttribute('status');
        parent::addAttribute('estados_id');
        parent::addAttribute('codigoibge');
    }

    
    /**
     * Method set_estados
     * Sample of usage: $cidades->estados = $object;
     * @param $object Instance of Estados
     */
    public function set_estados(Estados $object)
    {
        $this->estados = $object;
        $this->estados_id = $object->id;
    }
    
    /**
     * Method get_estados
     * Sample of usage: $cidades->estados->attribute;
     * @returns Estados instance
     */
    public function get_estados()
    {
        // loads the associated object
        if (empty($this->estados))
            $this->estados = new Estados($this->estados_id);
    
        // returns the associated object
        return $this->estados;
    }
    

    
    /**
     * Method getBairros
     */
    public function getBairros()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('cidades_id', '=', $this->id));
        return Bairro::getObjects( $criteria );
    }
    


}
