<?php
/**
 * Bairro Active Record
 * @author  <your-name-here>
 */
class Bairro extends TRecord
{
    const TABLENAME = 'bairro';
    const PRIMARYKEY= 'id';
    const IDPOLICY =  'max'; // {max, serial}
    
    
    private $cidades;

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('nome');
        parent::addAttribute('status');
        parent::addAttribute('cidades_id');
        parent::addAttribute('slug');
    }

    
    /**
     * Method set_cidades
     * Sample of usage: $bairro->cidades = $object;
     * @param $object Instance of Cidades
     */
    public function set_cidades(Cidades $object)
    {
        $this->cidades = $object;
        $this->cidades_id = $object->id;
    }
    
    /**
     * Method get_cidades
     * Sample of usage: $bairro->cidades->attribute;
     * @returns Cidades instance
     */
    public function get_cidades()
    {
        // loads the associated object
        if (empty($this->cidades))
            $this->cidades = new Cidades($this->cidades_id);
    
        // returns the associated object
        return $this->cidades;
    }
    

    
    /**
     * Method getImoveiss
     */
    public function getImoveiss()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('bairro_id', '=', $this->id));
        return Imoveis::getObjects( $criteria );
    }  
}
