 var map;
 var marker;
 var lat;
 var lng;

 function initialize() {
     var mapOptions = {
         center: new google.maps.LatLng(lat, lng),
         zoom: 11,
         mapTypeId: 'satelite'
     };

     map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions),
     createMarker(lat, lng)


     //var ctaLayer = new google.maps.KmlLayer('app/control/patrulha/geo/estados.kml' )//olhar url

 
     google.maps.event.addListener(map, "click", function(event) {

         var lat = event.latLng.lat().toFixed(6);
         var lng = event.latLng.lng().toFixed(6);
         createMarker(lat, lng);
         getCoords(lat, lng);

     });


 }

 google.maps.event.addDomListener(window, 'load', initialize);

 function createMarker(lat, lng) {


     if (marker) {
         
         marker.setMap(null);
         marker = "";
     }

     marker = new google.maps.Marker({

         position: new google.maps.LatLng(lat, lng),
         draggable: true,
         map: map
     });


     google.maps.event.addListener(marker, 'dragend', function() {

         marker.position = marker.getPosition();
         var lat = marker.position.lat().toFixed(6);
         var lng = marker.position.lng().toFixed(6);
         getCoords(lat, lng);

     });
 }


 function getCoords(lat, lng) {

     var coords_lat = document.getElementById('lat');  
     coords_lat.value = lat;
     var coords_lng = document.getElementById('lng');
     coords_lng.value = lng;
 }