<?php
/**
 * NoticiasList Listing
 * @author  <your name here>
 */
class NoticiasList extends TPage
{
    protected $form;     // registration form
    protected $datagrid; // listing
    protected $pageNavigation;
    protected $formgrid;
    protected $deleteButton;
    
    use Adianti\base\AdiantiStandardListTrait;
    
    /**
     * Page constructor
     */
    public function __construct()
    {
        parent::__construct();
        
        $this->setDatabase('imobiliaria');            // defines the database
        $this->setActiveRecord('Noticias');   // defines the active record
        $this->setDefaultOrder('id', 'asc');         // defines the default order
        $this->setLimit(10);
        // $this->setCriteria($criteria) // define a standard filter

        $this->addFilterField('titulo', 'like', 'titulo'); // filterField, operator, formField
        $this->addFilterField('dt', 'like', 'dt'); // filterField, operator, formField
        $this->addFilterField('publicar', 'like', 'publicar'); // filterField, operator, formField
        $this->addFilterField('home', 'like', 'home'); // filterField, operator, formField
        
        
        // creates the form
        $this->form = new BootstrapFormBuilder('form_search_Noticias');
        $this->form->setFormTitle('Lista Noticias');
        

        // create the form fields
        $titulo = new TEntry('titulo');
        $dt = new TDate('dt');
        $publicar = new TCombo('publicar');
        $home = new TCombo('home');
        
        $publicar->addItems( [ '1' => _t('Yes'), '0' => _t('No') ] );        
        $home->addItems( [ '1' => _t('Yes'), '0' => _t('No') ] );
        $dt->setDatabaseMask('yyyy-mm-dd');
        $dt->setMask('dd/mm/yyyy');


        // add the fields
        $this->form->addFields( [ new TLabel('Titulo') ], [ $titulo ] , [ new TLabel('Data') ], [ $dt ] );
        $this->form->addFields( [ new TLabel('Publicar') ], [ $publicar ] , [ new TLabel('Página Home') ], [ $home ] );


        // set sizes
        $titulo->setSize('100%');
        $dt->setSize('100%');
        $publicar->setSize('100%');
        $home->setSize('100%');

        
        // keep the form filled during navigation with session data
        $this->form->setData( TSession::getValue(__CLASS__.'_filter_data') );
        
        // add the search form actions
        $btn = $this->form->addAction(_t('Find'), new TAction([$this, 'onSearch']), 'fa:search');
        $btn->class = 'btn btn-sm btn-primary';
        $this->form->addActionLink(_t('New'), new TAction(['NoticiasForm', 'onEdit']), 'fa:plus green');
        
        // creates a Datagrid
        $this->datagrid = new BootstrapDatagridWrapper(new TDataGrid);
        $this->datagrid->style = 'width: 100%';
        $this->datagrid->datatable = 'true';
        // $this->datagrid->enablePopover('Popover', 'Hi <b> {name} </b>');
        

        // creates the datagrid columns
        $column_id = new TDataGridColumn('id', 'Id', 'right');
        $column_titulo = new TDataGridColumn('titulo', 'Titulo', 'left');
        $column_dt = new TDataGridColumn('dt', 'Data', 'left');
        $column_publicar = new TDataGridColumn('publicar', 'Publicar', 'left');
        $column_home = new TDataGridColumn('home', 'Home', 'left');
        $column_imagem = new TDataGridColumn('imagem', 'Imagem', 'left');


        // add the columns to the DataGrid
        $this->datagrid->addColumn($column_id);
        $this->datagrid->addColumn($column_titulo);
        $this->datagrid->addColumn($column_dt);
        $this->datagrid->addColumn($column_publicar);
        $this->datagrid->addColumn($column_home);
        $this->datagrid->addColumn($column_imagem);

        
        $column_titulo->setTransformer( function($value, $object, $row) {
           return strlen($value)> 45 ?   mb_substr($value,0, 45).'...' :   $value;      
        }); 
        
        
        // define the transformer method over image
        $column_dt->setTransformer( function($value, $object, $row) {
            if ($value) {                
                 $dt = new DateTime($value);
                 return $dt->format('d/m/Y'); 
             } 
        });
        
        
        // define the transformer method over image
        $column_imagem->setTransformer( function($value, $object, $row) {
            if (file_exists($value)) {
                $imagem= new TImage($value); 
                $imagem->style='width:100px';//tamanho da imagem no grid
                return $imagem;
             } 
        });
              
        $column_publicar->setTransformer( function($value, $object, $row) {
            $class = ($value=='0') ? 'danger' : 'success';
            $label = ($value=='0') ? _t('No') : _t('Yes');
            $div = new TElement('span');
            $div->class="label label-{$class}";
            $div->style="text-shadow:none; font-size:12px; font-weight:lighter";
            $div->add($label);
            return $div;
        });
      
      
      $column_home->setTransformer( function($value, $object, $row) {
            $class = ($value=='0') ? 'danger' : 'success';
            $label = ($value=='0') ? _t('No') : _t('Yes');
            $div = new TElement('span');
            $div->class="label label-{$class}";
            $div->style="text-shadow:none; font-size:12px; font-weight:lighter";
            $div->add($label);
            return $div;
        });
        

        
        $action1 = new TDataGridAction(['NoticiasForm', 'onEdit'], ['id'=>'{id}']);
        $action2 = new TDataGridAction([$this, 'onDelete'], ['id'=>'{id}']);
        
        $this->datagrid->addAction($action1, _t('Edit'),   'far:edit blue');
        $this->datagrid->addAction($action2 ,_t('Delete'), 'far:trash-alt red');
        
        // create the datagrid model
        $this->datagrid->createModel();
        
        // creates the page navigation
        $this->pageNavigation = new TPageNavigation;
        $this->pageNavigation->setAction(new TAction([$this, 'onReload']));
        
        $panel = new TPanelGroup('', 'white');
        $panel->add($this->datagrid);
        $panel->addFooter($this->pageNavigation);
        
        // header actions
        $dropdown = new TDropDown(_t('Export'), 'fa:list');
        $dropdown->setPullSide('right');
        $dropdown->setButtonClass('btn btn-default waves-effect dropdown-toggle');
        $dropdown->addAction( _t('Save as CSV'), new TAction([$this, 'onExportCSV'], ['register_state' => 'false', 'static'=>'1']), 'fa:table blue' );
        $dropdown->addAction( _t('Save as PDF'), new TAction([$this, 'onExportPDF'], ['register_state' => 'false', 'static'=>'1']), 'far:file-pdf red' );
        $panel->addHeaderWidget( $dropdown );
        
        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        // $container->add(new TXMLBreadCrumb('menu.xml', __CLASS__));
        $container->add($this->form);
        $container->add($panel);
        
        parent::add($container);
    }
   
       
    
    /**
     * Ask before deletion
     */
    public static function onDelete($param)
    {
        // define the delete action
        $action = new TAction([__CLASS__, 'Delete']);
        $action->setParameters($param); // pass the key parameter ahead
        
        // shows a dialog to the user
        new TQuestion(AdiantiCoreTranslator::translate('Do you really want to delete ?'), $action);
    }
    
    /**
     * Delete a record
     */
    public static function Delete($param)
    {
        try
        {
            $key = $param['key']; // get the parameter $key
            TTransaction::open('imobiliaria'); // open a transaction with database
            $object = new Noticias($key, FALSE); // instantiates the Active Record
           

            if( file_exists ( $object->imagem))//apaga a  imagem            
            {
               unlink($object->imagem);
            }   
            
             $object->delete(); // deletes the object from the database
            
            TTransaction::close(); // close the transaction
            
            $pos_action = new TAction([__CLASS__, 'onReload']);
            new TMessage('info', AdiantiCoreTranslator::translate('Record deleted'), $pos_action); // success message
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }
}
