<?php
/**
 * NoticiasForm Form
 * @author  <your name here>
 */
class NoticiasForm extends TPage
{
    protected $form; // form
    
    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param )
    {
        parent::__construct();
        
        
        // creates the form
        $this->form = new BootstrapFormBuilder('form_Noticias');
        $this->form->setFormTitle('Form Notícias');
        

        // create the form fields
        $id       = new TEntry('id');
        $titulo   = new TEntry('titulo');
        $imagem   = new TSlim('imagem');
        $dt       = new TDate('dt');
        $publicar = new TCombo('publicar');
        $home     = new TCombo('home');
        $video    = new TEntry('video');
        $tag      = new TCheckGroup('tag');
        $resumo   = new THtmlEditor('resumo');
        $materia  = new THtmlEditor('materia');
        $fonte    = new TEntry('fonte');
        
        $publicar->addItems( [ '1' => _t('Yes'), '0' => _t('No') ] );        
        $home->addItems( [ '1' => _t('Yes'), '0' => _t('No') ] );
        $dt->setDatabaseMask('yyyy-mm-dd');
        $dt->setMask('dd/mm/yyyy');
        $resumo->setSize(NULL, 80);
        $materia->setSize(NULL, 80);
        $options = ['Negócios '=>'Negócios', 'Investimento ' => 'Investimento', 'Arquitetura ' => 'Arquitetura', 'Design ' => 'Design'];
        $tag->addItems($options);
        $tag->setLayout('horizontal');


        // add the fields
        $this->form->addFields( [ new TLabel('Id') ], [ $id ] );
        $this->form->addFields( [ new TLabel('Titulo') ], [ $titulo ] ,[ new TLabel('Data') ], [ $dt ] );
        $this->form->addFields( [ new TLabel('Imagem') ], [ $imagem ] );       
        $this->form->addFields( [ new TLabel('Publicar') ], [ $publicar ] , [ new TLabel('Página Home') ], [ $home ] );
        $this->form->addFields( [ new TLabel('Link Video') ], [ $video ] );
        $this->form->addFields( [ new TLabel('Tag') ], [ $tag ] );
        $this->form->addFields( [ new TLabel('Fonte') ], [ $fonte ] );
        $this->form->addFields( [ new TLabel('Resumo') ], [ $resumo ] );
        $this->form->addFields( [ new TLabel('Materia') ], [ $materia ] );


        $titulo->addValidation('Titulo', new TRequiredValidator);
        $resumo->addValidation('Resumo', new TRequiredValidator);
        $materia->addValidation('Materia', new TRequiredValidator);
        $dt->addValidation('Data', new TRequiredValidator);
        $publicar->addValidation('Publicar?', new TRequiredValidator);
        $fonte->addValidation('Fonte da notícia', new TRequiredValidator);
        $imagem->container->style = 'width:100%;height:175px;border:1px solid #CCCCCC;border-radius: 10px;margin-bottom:10px';//tamanho do container do plugin no form
        $imagem->setDataProperties(['label'=>'Imagem Notícia']);
        $imagem->setDataProperties(['ratio'=>'1196:854']); 
        


        // set sizes
        $id->setSize('100%');
        $titulo->setSize('100%');
        $imagem->setSize('100%');
        $dt->setSize('100%');
        $publicar->setSize('100%');
        $home->setSize('100%');
        $video->setSize('100%');
        $tag->setSize('100%');
        $resumo->setSize('100%');
        $materia->setSize('100%');
        $fonte->setSize('100%');



        if (!empty($id))
        {
            $id->setEditable(FALSE);
        }
        
        /** samples
         $fieldX->addValidation( 'Field X', new TRequiredValidator ); // add validation
         $fieldX->setSize( '100%' ); // set size
         **/
         
        // create the form actions
        $btn = $this->form->addAction(_t('Save'), new TAction([$this, 'onSave']), 'fa:save');
        $btn->class = 'btn btn-sm btn-primary';
        $btn2= $this->form->addActionLink(_t('New'),  new TAction([$this, 'onEdit']), 'fa:eraser red');          
        $btn3 =  $this->form->addAction('Voltar',  new TAction(['NoticiasList', 'onReload']) , 'fa:table blue fa-3x');
        
                         
        $btn->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px';
        $btn2->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px';
        $btn3->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px'; 
        
        
        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        // $container->add(new TXMLBreadCrumb('menu.xml', __CLASS__));
        $container->add($this->form);
        
        parent::add($container);
    }

    /**
     * Save form data
     * @param $param Request
     */
    public function onSave( $param )
    {
        try
        {
            TTransaction::open('imobiliaria'); // open a transaction
            
            /**
            // Enable Debug logger for SQL operations inside the transaction
            TTransaction::setLogger(new TLoggerSTD); // standard output
            TTransaction::setLogger(new TLoggerTXT('log.txt')); // file
            **/
            
            $this->form->validate(); // validate form data
            $data = $this->form->getData(); // get form data as array
            
            $object = new Noticias;  // create an empty object
            $object->fromArray( (array) $data); // load the object with data
            
           
            $images = Slim::getImages();     
            
            $object2 = new Noticias($object->id); //objeto criado para testar se imagem foi repetida   
                        
            if ($images) {

                         
               $image = $images[0];
               // save output data if set
               if (isset($image['output']['data']))
               {
                  // Save the file
                  $name = $image['output']['name'];                   

                  $ext = pathinfo($name, PATHINFO_EXTENSION);                  
                  $texto = substr($name, 0, -3);
                  $texto = funcoes::name($texto);
         
                  // We'll use the output crop data                  
                  $datas = $image['output']['data'];  
                   
                  if($datas != null){
                     //salva o arquivo na pasta concatenado o nome com o tempo e o formato    
                     $output = Slim::saveFile($datas, $texto.'-'.time().'.'.$ext, 'assets/img/noticias/img/', false);
                  } 
                  
                  //edição de registro
                  if( $object2->imagem !=  $output )//se a imagem salva no banco for diferente da imagem slim
                  {
                     if( file_exists ($object2->imagem))// se existir apaga o anterior
                     {
                        unlink( $object2->imagem ); //apaga
                     }                   
                  } 
                                                    
                  $object->imagem = $output['path'];//recebe o caminho para salvar

               }
            }
            else{               
               $object->imagem = $object2->imagem;
            }
            

            if(empty($object->imagem)) {  //primeiro registro            
                throw new Exception( 'O campo "IMAGEM NOTÍCIA" é obrigatório');                     
            }    
            
            
            
            if($object->titulo){   
              $object->slug = funcoes::url_amigavel($object->titulo);           
            } 
            
            $object->tag = implode(',',$data->tag);//check tag
            
            
            $object->store(); // save the object
            
            // get the generated id
            $data->id = $object->id;
            
            $this->form->setData($data); // fill form data
            TTransaction::close(); // close the transaction
            
            new TMessage('info', TAdiantiCoreTranslator::translate('Record saved'), new TAction(['NoticiasList', 'onReload'] ) );


        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            $this->form->setData( $this->form->getData() ); // keep form data
            TTransaction::rollback(); // undo all pending operations
        }
    }
    
    /**
     * Clear form data
     * @param $param Request
     */
    public function onClear( $param )
    {
        $this->form->clear(TRUE);
    }
    
    /**
     * Load object to form data
     * @param $param Request
     */
    public function onEdit( $param )
    {
        try
        {
            if (isset($param['key']))
            {
                $key = $param['key'];  // get the parameter $key
                TTransaction::open('imobiliaria'); // open a transaction
                $object = new Noticias($key); // instantiates the Active Record
                
                $object->tag = explode(',',$object->tag); 
                $this->form->setData($object); // fill the form
                TTransaction::close(); // close the transaction
            }
            else
            {
                $this->form->clear(TRUE);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }
}
