<?php
/**
 * ImoveisList Listing
 * @author  <your name here>
 */
class ImoveisList extends TPage
{
    protected $form;     // registration form
    protected $datagrid; // listing
    protected $pageNavigation;
    protected $formgrid;
    protected $deleteButton;
        protected $transformCallback;
    
    use Adianti\base\AdiantiStandardListTrait;    		

    
    /**
     * Page constructor
     */
    public function __construct()
    {
        parent::__construct();
        
        $this->setDatabase('imobiliaria');            // defines the database
        $this->setActiveRecord('Imoveis');   // defines the active record
        $this->setDefaultOrder('id', 'asc');         // defines the default order
        $this->setLimit(10);
        TScript::create("$('input[name=\"cliente_id\"]').focus();");     //coloca o foco no   
        // $this->setCriteria($criteria) // define a standard filter

        $this->addFilterField('id', '=', 'id'); // filterField, operator, formField
        $this->addFilterField('clientes_id', '=', 'clientes_id'); // filterField, operator, formField
        //$cliente_seek = TButton::create('numerofazendobt',['ClienteSeek','onReload'],'','fa:search');
        $this->addFilterField('subcategoria_id', '=', 'subcategoria_id'); // filterField, operator, formField
        $this->addFilterField('bairro_id', '=', 'bairro_id'); // filterField, operator, formField
        $this->addFilterField('titulo', 'like', 'titulo'); // filterField, operator, formField
        $this->addFilterField('endereco', 'like', 'endereco'); // filterField, operator, formField
        $this->addFilterField('status', 'like', 'status'); // filterField, operator, formField
        $this->addFilterField('pagina', 'like', 'pagina'); // filterField, operator, formField
        
        // creates the form
        $this->form = new BootstrapFormBuilder('form_search_Imoveis');
        $this->form->setFormTitle('Imoveis');
        
        $criteria = new TCriteria();
        $criteria->add(new TFilter('status','=','1')); 
        
        
        // create the form fields
        $id              = new TEntry('id');
        $clientes_id     = new TDBUniqueSearch('clientes_id', 'imobiliaria', 'Clientes', 'id', 'nome', 'nome asc');        
        $subcategoria_id = new TDBCombo('subcategoria_id', 'imobiliaria', 'Subcategoria', 'id', '{Categoria->nome} - {nome}');
        $bairro_id       = new TDBUniqueSearch('bairro_id', 'imobiliaria', 'Bairro', 'id', '{Cidades->nome} - {nome}',null,  $criteria);
        $titulo          = new TEntry('titulo');
        $endereco        = new TEntry('endereco');
        $status          = new TCombo('status');
        $pagina          = new TCombo('pagina');         
       
        $status->addItems(array('1'=> 'Ativo', '0'=> 'Inativo'));
        $pagina->addItems(array('1'=> 'Home', '3'=> 'Slide', '2'=> 'Outras'));
        $clientes_id->setMinLength(1); 
        $clientes_id->style = "width:100%;heigth:30px;border:2px solid black";   
        $clientes_id->setMask('{id} - {nome}');


        
         $row = $this->form->addFields( [ new TLabel('id'),     $id ],
                                       [ new TLabel('Exibiçao'),  $status ],
                                       [ new TLabel('Pagina'), $pagina ],
                                       [ new TLabel('Clientes'),     $clientes_id ]);
        $row->layout = ['col-sm-1', 'col-sm-1', 'col-sm-4', 'col-sm-6' ];
        
        
        $row = $this->form->addFields( [ new TLabel('Subcategoria'),  $subcategoria_id ],
                                       [ new TLabel('Titulo'),     $titulo ],
                                       [ new TLabel('Bairro'),  $bairro_id ],
                                       [ new TLabel('Endereço'), $endereco ]);
        $row->layout = ['col-sm-2', 'col-sm-3', 'col-sm-3', 'col-sm-4' ];
        
        
        // add the fields
        //$this->form->addFields( [ new TLabel('Id') ], [ $id ],[ new TLabel('Exibição') ], [ $status ], [ new TLabel('Pagina') ], [ $pagina ] );
        //$this->form->addFields( [ new TLabel('Subcategoria') ], [ $subcategoria_id ], [ new TLabel('Clientes') ], [ $clientes_id ] );        
        //$this->form->addFields( [ new TLabel('Titulo') ], [ $titulo ] );
        //$this->form->addFields( [ new TLabel('Bairro') ], [ $bairro_id ] , [ new TLabel('Endereço') ], [ $endereco ] );



        // set sizes
        $id->setSize('100%');
        $clientes_id->setSize('100%');
        $subcategoria_id->setSize('100%');
        $bairro_id->setSize('100%');
        $titulo->setSize('100%');
        $endereco->setSize('100%');
        $status->setSize('100%');
        $pagina->setSize('100%');

        
        // keep the form filled during navigation with session data
        $this->form->setData( TSession::getValue(__CLASS__.'_filter_data') );
        
        // add the search form actions
        $btn = $this->form->addAction(_t('Find'), new TAction([$this, 'onSearch']), 'fa:search');
        $btn->class = 'btn btn-sm btn-primary';
        $btn2 = $this->form->addActionLink(_t('New'), new TAction(['ImoveisForm', 'onEdit']), 'fa:plus green');
        
        $btn->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px';
        $btn2->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px';

        
        // creates a Datagrid
        $this->datagrid = new BootstrapDatagridWrapper(new TDataGrid);
        $this->datagrid->style = 'width: 100%';
        $this->datagrid->datatable = 'true';
        // $this->datagrid->enablePopover('Popover', 'Hi <b> {name} </b>');
        

        // creates the datagrid columns
        $column_id = new TDataGridColumn('id', 'Id', 'left');
        $column_clientes_id = new TDataGridColumn('Clientes->nome', 'Clientes', 'left');
        $column_subcategoria_id = new TDataGridColumn('Subcategoria->nome', 'Subcategoria', 'left');
        $column_bairro_id = new TDataGridColumn('bairro_id', 'Bairro', 'left');
        $column_titulo = new TDataGridColumn('titulo', 'Titulo', 'left');
        $column_endereco = new TDataGridColumn('endereco', 'Endereco', 'left');
        $column_foto = new TDataGridColumn('foto', 'Foto', 'left');
        $column_status = new TDataGridColumn('status', 'Ativo', 'left');
        //$column_pagina = new TDataGridColumn('pagina', 'Pagina', 'right');
        
        $column_status->enableAutoHide(500);


        // add the columns to the DataGrid
        $this->datagrid->addColumn($column_id);
        $this->datagrid->addColumn($column_clientes_id);
        $this->datagrid->addColumn($column_subcategoria_id);
        $this->datagrid->addColumn($column_bairro_id);
        $this->datagrid->addColumn($column_titulo);
        $this->datagrid->addColumn($column_endereco);
        $this->datagrid->addColumn($column_foto);
        $this->datagrid->addColumn($column_status);
        //$this->datagrid->addColumn($column_pagina);
        
              
        
        // define the transformer method over image
        $column_foto->setTransformer( function($value, $object, $row) {
            if (file_exists($value)) {
                $imagem= new TImage($value); 
                $imagem->style='width:100px';//tamanho da imagem no grid
                return $imagem;
             } 
        });
        
        // define the transformer valor do status
        $column_status->setTransformer( function($value, $object, $row) {
            $class = ($value=='0') ? 'danger' : 'success';
            $label = ($value=='0') ? _t('No') : _t('Yes');
            $div = new TElement('span');
            $div->class="label label-{$class}";
            $div->style="text-shadow:none; font-size:12px; font-weight:lighter";
            $div->add($label);
            return $div;
        });
                
        // define the transformer valor da pagina
/*
        $column_pagina->setTransformer( function($value) { 
            if($value =='1'){ $x = "Home"; }
            if($value =='3'){ $x = "Slide"; }
            if($value =='2'){ $x = "Outras"; }            
            return $x;   
        });
*/
        
        
         // creates the datagrid column actions
        $column_id->setAction(new TAction([$this, 'onReload']), ['order' => 'id']);
        $column_clientes_id->setAction(new TAction([$this, 'onReload']), ['order' => 'clientes_id']);
        $column_subcategoria_id->setAction(new TAction([$this, 'onReload']), ['order' => 'subcategoria_id']);
        $column_bairro_id->setAction(new TAction([$this, 'onReload']), ['order' => 'bairro_id']);
        $column_titulo->setAction(new TAction([$this, 'onReload']), ['order' => 'titulo']);
        $column_status->setAction(new TAction([$this, 'onReload']), ['order' => 'status']);
        //$column_pagina->setAction(new TAction([$this, 'onReload']), ['order' => 'pagina']);
        
        
        $action1 = new TDataGridAction(['ImoveisForm', 'onEdit'], ['id'=>'{id}']);
        $action2 = new TDataGridAction([$this, 'onDelete'], ['id'=>'{id}']);
        $this->datagrid->addAction($action1, _t('Edit'),   'far:edit blue');
        
        
        // create addimages action status
        $action_addimg = new TDataGridAction(array($this, 'onAddImg'));
        $action_addimg->setButtonClass('btn btn-default');
        $action_addimg->setLabel('Add Imagens');
        $action_addimg->setImage('fa:images green');
        $action_addimg->setField('id');
        $this->datagrid->addAction($action_addimg);
        
        
        $this->datagrid->addAction($action2 ,_t('Delete'), 'far:trash-alt red');
        
        // create ONOFF action status
        $action_onoff = new TDataGridAction(array($this, 'onTurnOnOff'));
        $action_onoff->setButtonClass('btn btn-default');
        $action_onoff->setLabel(_t('Activate/Deactivate'));
        $action_onoff->setImage('fa:power-off orange');
        $action_onoff->setField('id');
        $this->datagrid->addAction($action_onoff);
        
        
        // create the datagrid model
        $this->datagrid->createModel();
        
        // creates the page navigation
        $this->pageNavigation = new TPageNavigation;
        $this->pageNavigation->setAction(new TAction([$this, 'onReload']));
        
        $panel = new TPanelGroup('', 'white');
        $panel->add($this->datagrid);
        $panel->addFooter($this->pageNavigation);
        
        // header actions
        $dropdown = new TDropDown(_t('Export'), 'fa:list');
        $dropdown->setPullSide('right');
        $dropdown->setButtonClass('btn btn-default waves-effect dropdown-toggle');
        $dropdown->addAction( _t('Save as CSV'), new TAction([$this, 'onExportCSV'], ['register_state' => 'false', 'static'=>'1']), 'fa:table blue' );
        $dropdown->addAction( _t('Save as PDF'), new TAction([$this, 'onExportPDF'], ['register_state' => 'false', 'static'=>'1']), 'far:file-pdf red' );
        $panel->addHeaderWidget( $dropdown );
        
        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        // $container->add(new TXMLBreadCrumb('menu.xml', __CLASS__));
        $container->add($this->form);
        $container->add($panel);
        
        parent::add($container);
    }
    
    
     /**
     * Turn on/off an user
     */
    public function onAddImg($param)
    {

        $par = ['imoveis_id' => $param['id']];
        TSession::setValue('parametro', $par);//setar para recuperar no list 
        TApplication::loadPage('ImagensFormList','onReload',$par);
    }
    
    
    
    
    /**
     * Turn on/off an user
     */
    public function onTurnOnOff($param)
    {
        try
        {
            TTransaction::open('imobiliaria');
            $user = Imoveis::find($param['id']);
            if ($user instanceof Imoveis)
            {
                $user->status = $user->status == '1' ? '0' : '1';
                $user->store();
            }
            
            TTransaction::close();
            
            $this->onReload($param);
        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }
    
    
    /**
     * Ask before deletion
     */
    public static function onDelete($param)
    {
        // define the delete action
        $action = new TAction([__CLASS__, 'Delete']);
        $action->setParameters($param); // pass the key parameter ahead
        
        // shows a dialog to the user
        new TQuestion(AdiantiCoreTranslator::translate('Do you really want to delete ?'), $action);
    }
    
    /**
     * Delete a record
     */
    public static function Delete($param)
    {
        try
        {
            $key = $param['key']; // get the parameter $key
            TTransaction::open('imobiliaria'); // open a transaction with database
            $object = new Imoveis($key, FALSE); // instantiates the Active Record
           

            if( file_exists ( $object->foto))//apaga a  imagem            
            {
               unlink($object->foto);
            }   
            
             $object->delete(); // deletes the object from the database
            
            TTransaction::close(); // close the transaction
            
            $pos_action = new TAction([__CLASS__, 'onReload']);
            new TMessage('info', AdiantiCoreTranslator::translate('Record deleted'), $pos_action); // success message
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }
    
   
}
