<?php
/**
 * ImoveisForm2 Master/Detail
 * @author  <your name here>
 */
class ImoveisForm2 extends TPage
{
    protected $form; // form
    protected $detail_list;
    
    /**
     * Page constructor
     */
    public function __construct()
    {
        parent::__construct();
        
        
        // creates the form
        $this->form = new BootstrapFormBuilder('form_Imoveis');
        $this->form->setFormTitle('Imoveis');
        
        
        
        $criteria = new TCriteria();
        $criteria->add(new TFilter('status','=','1'));  
        
        // master fields
        $id = new TEntry('id');
        $valor = new TEntry('valor');
        $status = new TCombo('status');
        $pagina = new TCombo('pagina');
        $clientes_id = new TDBUniqueSearch('clientes_id', 'imobiliaria', 'Clientes', 'id', 'nome', 'nome asc');        
        $categoria = new TDBCombo('categoria', 'imobiliaria', 'Categoria', 'id', 'nome',null);///
        $subcategoria_id = new TDBCombo('subcategoria_id', 'imobiliaria', 'Subcategoria', 'id', '{Categoria->nome} - {nome}');
        $cidade = new TDBCombo('cidade', 'imobiliaria', 'Cidades', 'id', 'nome');///
        $bairro_id = new TDBUniqueSearch('bairro_id', 'imobiliaria', 'Bairro', 'id', 'nome');
        $endereco = new TEntry('endereco');
        $titulo = new TEntry('titulo');
        $foto = new TSlim('foto');
        $descricao = new THtmlEditor('descricao');
        $quartos = new TEntry('quartos');
        $suites = new TEntry('suites');
        $banheiros = new TEntry('banheiros');
        $garagens = new TEntry('garagens');
        $area = new TEntry('area');
        $areaedificada = new TEntry('areaedificada');
        $areaconstruida = new TEntry('areaconstruida');
        $video = new TEntry('video');
        $opcionais = new TDBCheckGroup('opcionais', 'imobiliaria', 'Opcionais', 'id', 'nome');
        $latitude = new TEntry('latitude');
        $longitude = new TEntry('longitude');
        $agente = new TDBCheckGroup('agente', 'imobiliaria', 'Agente', 'id', 'nome');        

        
        //validações
        $descricao->setOption('placeholder', 'type here...');
        $opcionais->setLayout('horizontal');
        //$opcionais->setBreakItems(6);  
        $categoria->setChangeAction( new TAction( array($this, 'onCategoria_Change' )) );        
        $status->addItems(array('1'=> 'Ativo', '0'=> 'Inativo'));
        $pagina->addItems(array('1'=> 'Home', '3'=> 'Slide', '2'=> 'Outras'));
        $foto->container->style = 'width:100%;height:185px;border:2px solid #A2A2A2;border-radius: 10px;';//tamanho do container do plugin no form
        //$descricao->style = 'position: absolute !important;z-index: -222;';
        $foto->setDataProperties(['label'=>'Foto imóvel']);
        $foto->setDataProperties(['ratio'=>'1:1']);
        $descricao->setSize(null, 100);
        $valor->setNumericMask(2,',','.', true);
        $quartos->setMask('99');
        $area->setMask('99999');
        $suites->setMask('99');
        $garagens->setMask('99');
        $banheiros->setMask('99');
        $areaedificada->setMask('99999');
        $areaconstruida->setMask('99999');        
        $agente->setLayout('horizontal');
        $agente->setBreakItems(6); 
        
        $clientes_id->setMinLength(1); 
        $clientes_id->style = "width:100%;heigth:30px;border:2px solid black";   
        $clientes_id->setMask('{id} - {nome}');
        
        
        
        // detail fields
        $detail_uniqid = new THidden('detail_uniqid');
        $detail_id = new THidden('detail_id');
        $detail_nome = new TEntry('detail_nome');
        $detail_foto = new TFile('detail_foto');
        
        $detail_foto->setAllowedExtensions( ['gif', 'png', 'jpg', 'jpeg'] );
        // enable progress bar, preview
        $detail_foto->enableFileHandling();
        $detail_foto->enablePopover();
        

       

        if (!empty($id))
        {
            $id->setEditable(FALSE);
        }
        
        // master fields
        $this->form->addFields( [new TLabel('Id')], [$id] );
        $this->form->addFields( [new TLabel('Valor')], [$valor] );
        $this->form->addFields( [new TLabel('Status')], [$status] );
        $this->form->addFields( [new TLabel('Pagina')], [$pagina] );
        $this->form->addFields( [new TLabel('Clientes Id')], [$clientes_id] );
        $this->form->addFields( [new TLabel('Subcategoria Id')], [$subcategoria_id] );
        $this->form->addFields( [new TLabel('Bairro Id')], [$bairro_id] );
        $this->form->addFields( [new TLabel('Endereco')], [$endereco] );
        $this->form->addFields( [new TLabel('Titulo')], [$titulo] );
        $this->form->addFields( [new TLabel('Foto')], [$foto] );
        $this->form->addFields( [new TLabel('Descricao')], [$descricao] );
        $this->form->addFields( [new TLabel('Quartos')], [$quartos] );
        $this->form->addFields( [new TLabel('Suites')], [$suites] );
        $this->form->addFields( [new TLabel('Banheiros')], [$banheiros] );
        $this->form->addFields( [new TLabel('Garagens')], [$garagens] );
        $this->form->addFields( [new TLabel('Area')], [$area] );
        $this->form->addFields( [new TLabel('Areaedificada')], [$areaedificada] );
        $this->form->addFields( [new TLabel('Areaconstruida')], [$areaconstruida] );
        $this->form->addFields( [new TLabel('Video')], [$video] );
        $this->form->addFields( [new TLabel('Opcionais')], [$opcionais] );
        $this->form->addFields( [new TLabel('Latitude')], [$latitude] );
        $this->form->addFields( [new TLabel('Longitude')], [$longitude] );
        $this->form->addFields( [new TLabel('Agente')], [$agente] );
        
        
        //campos requeridos
        $clientes_id->addValidation('Clientes Id', new TRequiredValidator);
        $status->addValidation('Status', new TRequiredValidator);
        $pagina->addValidation('Pagina', new TRequiredValidator);
        $subcategoria_id->addValidation('Subcategoria Id', new TRequiredValidator);
        $bairro_id->addValidation('Bairro Id', new TRequiredValidator);
        $endereco->addValidation('Endereco', new TRequiredValidator);
        $descricao->addValidation('Descricao', new TRequiredValidator);
        $valor->addValidation('Valor', new TRequiredValidator);
        $quartos->addValidation('Quartos', new TRequiredValidator);
        $area->addValidation('Area', new TRequiredValidator);
        $suites->addValidation('Suites', new TRequiredValidator);
        $garagens->addValidation('Garagens', new TRequiredValidator);
        $banheiros->addValidation('Banheiros', new TRequiredValidator);
        $areaedificada->addValidation('Areaedificada', new TRequiredValidator);
        
        if (!empty($id))
        {
            $id->setEditable(FALSE);
        }
        
        
        // detail fields
        $this->form->addContent( ['<h4>Details</h4><hr>'] );
        $this->form->addFields( [$detail_uniqid] );
        $this->form->addFields( [$detail_id] );
        
        $this->form->addFields( [new TLabel('Nome')], [$detail_nome] );
        $this->form->addFields( [new TLabel('Foto')], [$detail_foto] );

        $add = TButton::create('add', [$this, 'onDetailAdd'], 'Register', 'fa:plus-circle green');
        $add->getAction()->setParameter('static','1');
        $this->form->addFields( [], [$add] );
        
        $this->detail_list = new BootstrapDatagridWrapper(new TDataGrid);
        $this->detail_list->setId('Imagens_list');
        $this->detail_list->generateHiddenFields();
        $this->detail_list->style = "min-width: 700px; width:100%;margin-bottom: 10px";
        
        // items
        $this->detail_list->addColumn( new TDataGridColumn('uniqid', 'Uniqid', 'center') )->setVisibility(false);
        $this->detail_list->addColumn( new TDataGridColumn('id', 'Id', 'center') )->setVisibility(false);
        $this->detail_list->addColumn( new TDataGridColumn('nome', 'Nome', 'left', 100) );
        $this->detail_list->addColumn( new TDataGridColumn('foto', 'Foto', 'left', 100) );

        // detail actions
        $action1 = new TDataGridAction([$this, 'onDetailEdit'] );
        $action1->setFields( ['uniqid', '*'] );
        
        $action2 = new TDataGridAction([$this, 'onDetailDelete']);
        $action2->setField('uniqid');
        
        // add the actions to the datagrid
        $this->detail_list->addAction($action1, _t('Edit'), 'fa:edit blue');
        $this->detail_list->addAction($action2, _t('Delete'), 'far:trash-alt red');
        
        $this->detail_list->createModel();
        
        $panel = new TPanelGroup;
        $panel->add($this->detail_list);
        $panel->getBody()->style = 'overflow-x:auto';
        $this->form->addContent( [$panel] );
        
        $this->form->addAction( 'Save',  new TAction([$this, 'onSave'], ['static'=>'1']), 'fa:save green');
        $this->form->addAction( 'Clear', new TAction([$this, 'onClear']), 'fa:eraser red');
        
        // create the page container
        $container = new TVBox;
        $container->style = 'width: 100%';
        // $container->add(new TXMLBreadCrumb('menu.xml', __CLASS__));
        $container->add($this->form);
        parent::add($container);
    }
    
    
   public static function onCategoria($param)
    {
        try
        {
            TTransaction::open('imobiliaria');

            if ($param['key'])
            { 
            
                //$sub  = Subcategoria::where('id', '=', $cidade)->load();   
                $repository = new TRepository('Imobiliaria');
                $criteria = new TCriteria;
                $criteria->add(new TFilter('categoria_id','=',$param['categoria']));
                $criteria->setProperty('order', 'nome');
                $criteria->setProperty('direction','ASC');
                $subcat = Subcategoria::getObjects($criteria); 
                $array_subs = [];            
                if ($subcat)
                {
                    foreach ($subcat as $subcats)
                    {
                       $array_subs[$subcats->id] = $subcats->nome;
                    }                     
                }                                         

                TDBCombo::reload('form_Imoveis', 'subcategoria_id', $array_subs);
        		        	

           }
            
            TTransaction::close();
        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    }
    
    
    /**
     * Popular Combo Subcategoria
     * @param $param Request
     */   
    
    public static function onCategoria_Change($param)
    {
     try
        {
            TTransaction::open('imobiliaria');

            if ($param['key'])
            { 
            
                //$sub  = Subcategoria::where('id', '=', $cidade)->load();   
                $repository = new TRepository('categoria');
                $criteria = new TCriteria;
                $criteria->add(new TFilter('categoria_id','=',$param['categoria']));
                $criteria->setProperty('order', 'nome');
                $criteria->setProperty('direction','ASC');
                $subcat = Subcategoria::getObjects($criteria); 
                $array_subs = [];            
                if ($subcat)
                {
                    foreach ($subcat as $subcats)
                    {
                       $array_subs[$subcats->id] = $subcats->nome;
                    }                     
                }                                         

                TDBCombo::reload('form_Imoveis', 'subcategoria_id', $array_subs);
        		$objForm = new stdclass();                 
            	TForm::sendData('form_Imoveis',$objForm,false);   
            	//TSession::setValue('zona_rural_id'.__CLASS__, $array_zonas);            	

           }
            
            TTransaction::close();
        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
       
    }
   
    /**
     * Clear form
     * @param $param URL parameters
     */
    public function onClear($param)
    {
        $this->form->clear(TRUE);
    }
    
    /**
     * Add detail item
     * @param $param URL parameters
     */
    public function onDetailAdd( $param )
    {
        try
        {
            $this->form->validate();
            $data = $this->form->getData();
            
            /** validation sample
            if (empty($data->fieldX))
            {
                throw new Exception('The field fieldX is required');
            }
            **/
            
            $uniqid = !empty($data->detail_uniqid) ? $data->detail_uniqid : uniqid();
            
            $grid_data = [];
            $grid_data['uniqid'] = $uniqid;
            $grid_data['id'] = $data->detail_id;
            $grid_data['nome'] = $data->detail_nome;
            $grid_data['foto'] = $data->detail_foto;
            
            // insert row dynamically
            $row = $this->detail_list->addItem( (object) $grid_data );
            $row->id = $uniqid;
            
            TDataGrid::replaceRowById('Imagens_list', $uniqid, $row);
            
            // clear detail form fields
            $data->detail_uniqid = '';
            $data->detail_id = '';
            $data->detail_nome = '';
            $data->detail_foto = '';
            
            // send data, do not fire change/exit events
            TForm::sendData( 'form_Imoveis', $data, false, false );
        }
        catch (Exception $e)
        {
            $this->form->setData( $this->form->getData());
            new TMessage('error', $e->getMessage());
        }
    }
    
    /**
     * Edit detail item
     * @param $param URL parameters
     */
    public static function onDetailEdit( $param )
    {
        $data = new stdClass;
        $data->detail_uniqid = $param['uniqid'];
        $data->detail_id = $param['id'];
        $data->detail_nome = $param['nome'];
        $data->detail_foto = $param['foto'];
        
        // send data, do not fire change/exit events
        TForm::sendData( 'form_Imoveis', $data, false, false );
    }
    
    /**
     * Delete detail item
     * @param $param URL parameters
     */
    public static function onDetailDelete( $param )
    {
        // clear detail form fields
        $data = new stdClass;
        $data->detail_uniqid = '';
        $data->detail_id = '';
        $data->detail_nome = '';
        $data->detail_foto = '';
        
        // send data, do not fire change/exit events
        TForm::sendData( 'form_Imoveis', $data, false, false );
        
        // remove row
        TDataGrid::removeRowById('Imagens_list', $param['uniqid']);
    }
    
    /**
     * Load Master/Detail data from database to form
     */
    public function onEdit($param)
    {
        try
        {
            TTransaction::open('imobiliaria');
            
            if (isset($param['key']))
            {
                $key = $param['key'];
                
                $object = new Imoveis($key);
                

                
                $Subcategorias = Subcategoria::where('id', '=', $object->subcategoria_id)->take(1)->load();                
                if ($Subcategorias[0])
                {
                    $categoria = $Subcategorias[0];
                    echo "a categoria  é: ".$categoria->id;
                    $filter = new TCriteria;
                    $filter->add(new TFilter('categoria_id', '=', $categoria->id));// seleciona o cadastrado no bd  
                }                
                
                $object->opcionais = explode(',',$object->opcionais); 
                $object->agente = explode(',',$object->agente); 
                
                
                
                $items  = Imagens::where('imoveis_id', '=', $key)->load();
                
                foreach( $items as $item )
                {
                    $item->uniqid = uniqid();
                    $row = $this->detail_list->addItem( $item );
                    $row->id = $item->uniqid;
                }
                $this->form->setData($object);
                TTransaction::close();
            }
            else
            {
                $this->form->clear(TRUE);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }
    
    /**
     * Save the Master/Detail data from form to database
     */
    public function onSave($param)
    {
        try
        {
            // open a transaction with database
            TTransaction::open('imobiliaria');
            
            $data = $this->form->getData();
            $this->form->validate();
            
            $master = new Imoveis;
            $master->fromArray( (array) $data);
            
            
           /////////////bloco salvar a imagem
            $images = Slim::getImages();  
            $object2 = new Imoveis($master->id); //objeto criado para testar se imagem foi repetida             
            if ($images) {                         
               $image = $images[0];
               // save output data if set
               if (isset($image['output']['data']))
               {
                  // Save the file
                  $name = $image['output']['name'];                    
                  $ext = pathinfo($name, PATHINFO_EXTENSION);                  
                  $texto = substr($name, 0, -3);
                  $texto = funcoes::name($texto);   
                  // We'll use the output crop data                  
                  $datas = $image['output']['data'];                    
                  if($datas != null){
                     //salva o arquivo na pasta img/depoimentos concatenado o nome com o tempo e o formato    
                     $output = Slim::saveFile($datas, $texto.'-'.time().'.'.$ext, 'assets/img/imoveis/', false);
                  }                   
                  if( $object2->foto !=  $output )//se a imagem do banco for diferente da imagem slim
                  {
                     if( file_exists ($object2->foto))// se existir apaga o anterior
                     {
                        unlink( $object2->foto ); //apaga
                     }                   
                  }                 
                  $master->foto = $output['path'];//recebe o caminho para salvar                  
               }
            }
            else{                           
               $master->foto = $object2->foto;               
            }  
            if(empty($master->foto)) {//primeiro registro            
                throw new Exception( 'O campo "FOTO" é obrigatório');                                     
            }
 ///////////fim bloco
 
 
            
            
            
 

            $master->opcionais = implode(',',$data->opcionais);
            $master->agente = implode(',',$data->agente); 
            
            
            
            
            
            
            
            
            
            
            
            $master->store();
            
            // copy file to target folder

            
            Imagens::where('imoveis_id', '=', $master->id)->delete();
            
            if( $param['Imagens_list_nome'] )
            {
                foreach( $param['Imagens_list_nome'] as $key => $item_id )
                {
                    $detail = new Imagens;
                    $detail->nome  = $param['Imagens_list_nome'][$key];
                    $detail->foto  = $param['Imagens_list_foto'][$key];
                    $detail->imoveis_id = $master->id;
                    $detail->store();
                    $this->saveFile($detail, $data, 'Imagens_list_foto', 'assets/img/interiores/');
                }
            }

            
            TTransaction::close(); // close the transaction
            
            TForm::sendData('form_Imoveis', (object) ['id' => $master->id]);
            
            new TMessage('info', AdiantiCoreTranslator::translate('Record saved'));
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage());
            $this->form->setData( $this->form->getData() ); // keep form data
            TTransaction::rollback();
        }
    }
}
