<?php
/**
 * ImoveisForm Form
 * @author  <your name here>
 */
class ImoveisForm extends TPage
{
    protected $form; // form
    
    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param )
    {
        parent::__construct();        
        
       
        parent::include_css('app/control/imobiliaria/geo/style.css'); 
        // creates the form
        $this->form = new BootstrapFormBuilder('form_Imoveis');
        $this->form->setFormTitle('Form Imóveis');  
        $this->form->setFieldSizes('100%');
        
        TScript::create("$('input[name=\"valor\"]').focus();"); 
              
        $criteria = new TCriteria();
        $criteria->add(new TFilter('status','=','1'));     
                

        // master fields
        $id = new TEntry('id');
        $clientes_id = new TDBUniqueSearch('clientes_id', 'imobiliaria', 'Clientes', 'id', 'nome', 'nome asc');        
        //$clientes_id = new TDBUniqueSearch('clientes_id', 'imobiliaria', 'Clientes', 'id', 'nome', 'nome asc');
        //$clientes_id = new TDBCombo('clientes_id', 'imobiliaria', 'Clientes', 'id', '{nome}'.' - '.'{id}', 'nome asc');
        $status = new TCombo('status');
        $pagina = new TCombo('pagina');
        //$categoria = new TDBCombo('categoria', 'imobiliaria', 'Categoria', 'id', 'nome',null);///
        //$categoria = new TDBCombo('categoria', 'imobiliaria', 'Categoria', 'id', 'nome',null, $criteria);///
        $subcategoria_id = new TDBCombo('subcategoria_id', 'imobiliaria', 'Subcategoria', 'id', '{Categoria->nome} - {nome}');
        $foto = new TSlim('foto');
        $titulo = new TEntry('titulo');
        //$cidade = new TDBCombo('cidade', 'imobiliaria', 'Cidades', 'id', 'nome');///
        $bairro_id = new TDBCombo('bairro_id', 'imobiliaria', 'Bairro', 'id', '{Cidades->nome} - {nome}', null,  $criteria);
        $endereco = new TEntry('endereco');
        $descricao = new THtmlEditor('descricao');
        $valor = new TEntry('valor');
        $quartos = new TEntry('quartos');
        $area = new TEntry('area');
        $suites = new TEntry('suites');
        $garagens = new TEntry('garagens');
        $banheiros = new TEntry('banheiros');
        $areaedificada = new TEntry('areaedificada');
        $areaconstruida = new TEntry('areaconstruida');
        $opcionais = new TDBCheckGroup('opcionais', 'imobiliaria', 'Opcionais', 'id', 'nome');
        $video = new TEntry('video');
        $latitude = new TEntry('latitude');
        $longitude = new TEntry('longitude');
        $agente = new TDBCheckGroup('agente', 'imobiliaria', 'Agente', 'id', 'nome');        
        
        
        //validações
        $descricao->setOption('placeholder', 'type here...');
        $opcionais->setLayout('horizontal');
        //$opcionais->setBreakItems(6);  
        //$categoria->setChangeAction( new TAction( array($this, 'onCategoria_Change' )) );        
        $status->addItems(array('1'=> 'Ativo', '0'=> 'Inativo'));
        $pagina->addItems(array('1'=> 'Home', '3'=> 'Slide', '2'=> 'Outras'));
        $foto->container->style = 'width:100%;height:185px;border:2px solid #A2A2A2;border-radius: 10px;';//tamanho do container do plugin no form
        //$descricao->style = 'position: absolute !important;z-index: -222;';
        $foto->setDataProperties(['label'=>'Foto imóvel']);
        $foto->setDataProperties(['ratio'=>'95:48']);
        $descricao->setSize(null, 100);
        $valor->setNumericMask(2,',','.', true);
        $quartos->setMask('99');
        $area->setMask('99999');
        $suites->setMask('99');
        $garagens->setMask('99');
        $banheiros->setMask('99');
        $areaedificada->setMask('99999');
        $areaconstruida->setMask('99999');        
        $agente->setLayout('horizontal');
        $agente->setBreakItems(6); 
        
        $clientes_id->setMinLength(1); 
        $clientes_id->style = "width:100%;heigth:30px;border:2px solid black";   
        $clientes_id->setMask('{id} - {nome}');
        
        //placeholder
        $valor->placeholder = 'R$';


        

        $row = $this->form->addFields( [ new TLabel('id'),     $id ],
                                       [ new TLabel('Valor<font color="red">*</font>'),  $valor ],
                                       [ new TLabel('Status<font color="red">*</font>'), $status ],
                                       [ new TLabel('Página<font color="red">*</font>'), $pagina ]);
        $row->layout = ['col-sm-3', 'col-sm-3', 'col-sm-3', 'col-sm-3' ];
        
        
        $row = $this->form->addFields( [ new TLabel('Cliente<font color="red">*</font>'), $clientes_id ]);
        $row->layout = ['col-sm-12' ];
        
        
        $row = $this->form->addFields( [ new TLabel('Subcategoria<font color="red">*</font>'),$subcategoria_id ],
                                       [ new TLabel('Título'),  $titulo ]);
        $row->layout = ['col-sm-6', 'col-sm-6' ];     
       
             
        
        $row = $this->form->addFields( [ new TLabel('Endereço'),$endereco ],
                                       [ new TLabel('Bairro<font color="red">*</font>'), $bairro_id ]);
        $row->layout = ['col-sm-6', 'col-sm-6' ];
        
        
        $row = $this->form->addFields( [ new TLabel('Foto'),      $foto ],
                                       [ new TLabel('Descrição<font color="red">*</font>'), $descricao ]);
        $row->layout = ['col-sm-6', 'col-sm-6' ];
        
        
        $subform = new BootstrapFormBuilder;
        $subform->setFieldSizes('100%');
        $subform->setProperty('style', 'width:100%;min-height:320px;border:2px solid #A2A2A2;border-radius: 5px;'); 
        
             
             
        
        $subform->appendPage( 'Opcionais' );        
        
        $row = $subform->addFields( [ new TLabel('Quartos<font color="red">*</font>'), $quartos ],
                                    [ new TLabel('Suítes<font color="red">*</font>'),   $suites ],
                                    [ new TLabel('Banheiros<font color="red">*</font>'),$banheiros ],
                                    [ new TLabel('Garagens<font color="red">*</font>'), $garagens ] );
        $row->layout = ['col-sm-3', 'col-sm-3', 'col-sm-3', 'col-sm-3' ];
        
        
        $row = $subform->addFields( [ new TLabel('Área Total(m)<sup>2</sup><font color="red">*</font>'),     $area ],
                                    [ new TLabel('Área Edificada(m)<sup>2</sup><font color="red">*</font>'), $areaedificada ],
                                    [ new TLabel('Área Construida(m)<sup>2</sup>'),$areaconstruida] );
        $row->layout = ['col-sm-4', 'col-sm-4', 'col-sm-4' ];
        
        
        $row = $subform->addFields( [ new TLabel('URL Video Youtube'), $video ] );
        $row->layout = ['col-sm-12'];
        
        $row = $subform->addFields( [new TFormSeparator(''   ,'#333333',  '18')] );
        $row->layout = ['col-sm-12'];  
        
        
        $row = $subform->addFields( [ new TLabel('Outros'), $opcionais ] );
        $row->layout = ['col-sm-12'];  
        
        
        
        
       
        $subform->appendPage( 'Localização' );

        
        $row = $subform->addFields( [ new TLabel('Latitude.'), $latitude ],
                                    [ new TLabel('Longitude'), $longitude ]);
        $row->layout = ['col-sm-6', 'col-sm-6'];
        
        
        
        
        //criar a div mapa
        $div1 = new TElement('div');       
        $div1->{'id'} = 'map-canvas';  
        $div1->style = 'width:100%;height:280px;border: 1px solid black;';  //aqui defino o tamanho do mapa
        $row = $subform->addFields([$div1]);;
        
        
        
                
                
                
        $subform->appendPage( 'Agente' );
        
        $row = $subform->addFields( [ new TLabel(''), $agente ]);
        $row->layout = ['col-sm-12'];
        
        
      
               
                
        // add the fields
        //$this->form->addFields( [ new TLabel('Id') ], [ $id ],  [ new TLabel('Status') ], [ $status ] , [ new TLabel('Pagina') ], [ $pagina ]  );
        //$this->form->addFields( [ new TLabel('Cliente') ], [ $clientes_id ] );
        //$this->form->addFields( [ new TLabel('Categoria') ], [ $categoria ] , [ new TLabel('Subcategoria') ], [ $subcategoria_id ] );
        //$this->form->addFields( [ new TLabel('Cidade') ], [ $cidade ] , [ new TLabel('Bairro') ], [ $bairro_id ] );
        //$this->form->addFields( [ new TLabel('Foto') ], [ $foto ] );
        //$this->form->addFields( [ new TLabel('Titulo') ], [ $titulo ] );        
        //$this->form->addFields( [ new TLabel('Endereco') ], [ $endereco ] );
        //$this->form->addFields( [ new TLabel('Descricao') ], [ $descricao ] );
        //$this->form->addFields( [ new TLabel('Quartos') ], [ $quartos ] , [ new TLabel('Suites') ], [ $suites ], [ new TLabel('Banheiros') ], [ $banheiros ] );
        //$this->form->addFields( [ new TLabel('Area') ], [ $area ], [ new TLabel('Areaedificada') ], [ $areaedificada ] , [ new TLabel('Areaconstruida') ], [ $areaconstruida ] );
        //$this->form->addFields( [ new TLabel('Valor') ], [ $valor ] );
        ///$this->form->addFields( [ new TLabel('Opcionais') ], [ $opcionais ] );
        //$this->form->addFields( [ new TLabel('Video') ], [ $video ] );
        //$this->form->addFields( [ new TLabel('Latitude') ], [ $latitude ] );
        //$this->form->addFields( [ new TLabel('Longitude') ], [ $longitude ] );
        //$this->form->addFields( [ new TLabel('Agente') ], [ $agente ] );

        $clientes_id->addValidation('Clientes Id', new TRequiredValidator);
        $status->addValidation('Status', new TRequiredValidator);
        $pagina->addValidation('Pagina', new TRequiredValidator);
        $subcategoria_id->addValidation('Subcategoria Id', new TRequiredValidator);
        $bairro_id->addValidation('Bairro Id', new TRequiredValidator);
        //$endereco->addValidation('Endereco', new TRequiredValidator);
        $descricao->addValidation('Descricao', new TRequiredValidator);
        $valor->addValidation('Valor', new TRequiredValidator);
        $quartos->addValidation('Quartos', new TRequiredValidator);
        $area->addValidation('Area', new TRequiredValidator);
        $suites->addValidation('Suites', new TRequiredValidator);
        $garagens->addValidation('Garagens', new TRequiredValidator);
        $banheiros->addValidation('Banheiros', new TRequiredValidator);
        $areaedificada->addValidation('Areaedificada', new TRequiredValidator);
        //$latitude->addValidation('Latitude', new TRequiredValidator);
        //$longitude->addValidation('Longitude', new TRequiredValidator);
        //$latitude->addValidation('Latitude',        new TMinLengthValidator, array(7));         
        //$longitude->addValidation('Longitude',       new TMinLengthValidator, array(7));
        
        
        $latitude->name   = 'lat';
        $longitude->name  = 'lng'; 
        
        $latitude->id   = 'lat';
        $longitude->id  = 'lng'; 


/*
        // set sizes
        $id->setSize('100%');
        $clientes_id->setSize('100%');
        $status->setSize('100%');
        $pagina->setSize('100%');
        $subcategoria_id->setSize('100%');
        $foto->setSize('100%');
        $titulo->setSize('100%');
        $bairro_id->setSize('100%');
        $endereco->setSize('100%');
        $descricao->setSize('100%');
        $valor->setSize('100%');
        $quartos->setSize('100%');
        $area->setSize('100%');
        $suites->setSize('100%');
        $garagens->setSize('100%');
        $banheiros->setSize('100%');
        $areaedificada->setSize('100%');
        $areaconstruida->setSize('100%');
        $opcionais->setSize('100%');
        $video->setSize('100%');
        $latitude->setSize('100%');
        $longitude->setSize('100%');
        $agente->setSize('100%');
*/


        if (!empty($id))
        {
            $id->setEditable(FALSE);
        }
        
        /** samples
         $fieldX->addValidation( 'Field X', new TRequiredValidator ); // add validation
         $fieldX->setSize( '100%' ); // set size
         **/
         
       
        
        // add field list to the form
        $this->form->addContent( [$this->fieldlist] );
        
        //adiciona as abas 
        $this->form->addContent( [$subform] );         
         
        // create the form actions
        $btn = $this->form->addAction(_t('Save'), new TAction([$this, 'onSave']), 'fa:save');
        $btn->class = 'btn btn-sm btn-primary';
        $btn2 =$this->form->addActionLink(_t('New'),  new TAction([$this, 'onEdit']), 'fa:eraser red');
        $btn3 =  $this->form->addAction('Voltar',  new TAction(['ImoveisList', 'onReload']) , 'fa:table blue fa-3x');
        
        $btn->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px';
        $btn2->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px';
        $btn3->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px';

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        // $container->add(new TXMLBreadCrumb('menu.xml', __CLASS__));
        $container->add($this->form);
        
        parent::add($container);

        TPage::include_js('https://maps.googleapis.com/maps/api/js?sensor=false&key=AIzaSyA4wqZZW7kw2wRh9PHIFjJdgLqVvoEXcUM&callback=initialize'); 
        TPage::include_js('app/control/imobiliaria/geo/map.js'); 
        
                  TScript::create('               
               
               $("#lat").mask("-AB.CDEFGH", {
                translation: {
                  "A": { pattern: /[1-1]/, optional: false},
                  "B": { pattern: /[2-9]/, optional: false},
                  "C": { pattern: /[0-9]/, optional: false},
                  "D": { pattern: /[0-9]/, optional: false},
                  "E": { pattern: /[0-9]/, optional: false},
                  "F": { pattern: /[0-9]/, optional: true},
                  "G": { pattern: /[0-9]/, optional: true},          
                  "H": { pattern: /[0-9]/, optional: true},
                    }                    
                });
                
                
                $("#lng").mask("-AB.CDEFGH", {
                translation: {
                  "A": { pattern: /[4-5]/, optional: false},
                  "B": { pattern: /[0-9]/, optional: false},
                  "C": { pattern: /[0-9]/, optional: false},
                  "D": { pattern: /[0-9]/, optional: false},
                  "E": { pattern: /[0-9]/, optional: false},
                  "F": { pattern: /[0-9]/, optional: true},
                  "G": { pattern: /[0-9]/, optional: true},             
                  "H": { pattern: /[0-9]/, optional: true},
                    }                    
                });    
                   

          ');
        
        
        
        if (isset($param['key'])) 
        {
           try
           {
              $key = $param['key'];  // get the parameter $key
              TTransaction::open('imobiliaria'); // open a transaction 
                           
              $object = new Imoveis($key); // instantiates the Active Record
              TScript::create('lat = -17.736154; lng = -49.173364;');     //passar as coordenadas no caso de inserção      
              TPage::include_js('https://maps.googleapis.com/maps/api/js?sensor=false&key=AIzaSyA4wqZZW7kw2wRh9PHIFjJdgLqVvoEXcUM&callback=initialize');                      
              
              TTransaction::close(); // close the transaction
            
          }
          catch (Exception $e) // in case of exception
          {
             new TMessage('error', $e->getMessage()); // shows the exception error message
             TTransaction::rollback(); // undo all pending operations
          }
                             
        } 
    }
     
    
   

    
     public static function onCategoria($param)
    {
        try
        {
            TTransaction::open('imobiliaria');

            if ($param['key'])
            { 
            
                //$sub  = Subcategoria::where('id', '=', $cidade)->load();   
                $repository = new TRepository('Imobiliaria');
                $criteria = new TCriteria;
                $criteria->add(new TFilter('categoria_id','=',$param['categoria']));
                $criteria->setProperty('order', 'nome');
                $criteria->setProperty('direction','ASC');
                $subcat = Subcategoria::getObjects($criteria); 
                $array_subs = [];            
                if ($subcat)
                {
                    foreach ($subcat as $subcats)
                    {
                       $array_subs[$subcats->id] = $subcats->nome;
                    }                     
                }                                         

                TDBCombo::reload('form_Imoveis', 'subcategoria_id', $array_subs);
        		        	

           }
            
            TTransaction::close();
        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    }   
    
    
   
    /**
     * Save form data
     * @param $param Request
     */
    public function onSave( $param )
    {
        try
        {
            TTransaction::open('imobiliaria'); // open a transaction
            
            /**
            // Enable Debug logger for SQL operations inside the transaction
            TTransaction::setLogger(new TLoggerSTD); // standard output
            TTransaction::setLogger(new TLoggerTXT('log.txt')); // file
            **/
            
            $this->form->validate(); // validate form data
            $data = $this->form->getData(); // get form data as array
            
            $object = new Imoveis;  // create an empty object
            $object->fromArray( (array) $data); // load the object with data
            
            
/////////////bloco salvar a imagem
            $images = Slim::getImages();  
            $object2 = new Imoveis($object->id); //objeto criado para testar se imagem foi repetida             
            if ($images) {                         
               $image = $images[0];
               // save output data if set
               if (isset($image['output']['data']))
               {
                  // Save the file
                  $name = $image['output']['name'];                    
                  $ext = pathinfo($name, PATHINFO_EXTENSION);                  
                  $texto = substr($name, 0, -3);
                  $texto = funcoes::name($texto);   
                  // We'll use the output crop data                  
                  $datas = $image['output']['data'];                    
                  if($datas != null){
                     //salva o arquivo na pasta img/depoimentos concatenado o nome com o tempo e o formato    
                     $output = Slim::saveFile($datas, $texto.'-'.time().'.'.$ext, '../assets/img/imoveis/', false);
                  }                   
                  if( $object2->foto !=  $output )//se a imagem do banco for diferente da imagem slim
                  {
                     if( file_exists ($object2->foto))// se existir apaga o anterior
                     {
                        unlink( $object2->foto ); //apaga
                     }                   
                  }                 
                  $object->foto = $output['path'];//recebe o caminho para salvar                  
               }
            }
            else{                           
               $object->foto = $object2->foto;               
            }  
            if(empty($object->foto)) {//primeiro registro            
                throw new Exception( 'O campo "FOTO" é obrigatório');                                     
            }
 ///////////fim bloco
             
 

            $object->opcionais = implode(',',$data->opcionais);
            $object->agente = implode(',',$data->agente);
            
            //Validação latitude
            if(strlen($data->latitude) < 7){          
                throw new Exception( 'O campo "Latitude" deve conter no mínimo 7 caracters' );          
            }
            if(strlen($data->longitude) < 7){          
                 throw new Exception( 'O campo "Longitude" deve conter no mínimo 7 caracters' );          
            }
       
       
            
            $object->store(); // save the object
            
            //Renderizar o mapa nas coordenadas salvas            
            TScript::create('lat = ' . $object->latitude . ';lng = '. $object->longitude.';');//carrega a lat e lng atual 
            
            // get the generated id
            $data->id = $object->id;
             $data->foto = $object->foto;
            
            $this->form->setData($data); // fill form data
            TTransaction::close(); // close the transaction
            
            new TMessage('info', AdiantiCoreTranslator::translate('Record saved'));
            //new TMessage('info', TAdiantiCoreTranslator::translate('Record saved'), new TAction(['ImoveisList', 'onReload'] ) );
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            $this->form->setData( $this->form->getData() ); // keep form data
            TTransaction::rollback(); // undo all pending operations
        }
    }
    
    /**
     * Clear form data
     * @param $param Request
     */
    public function onClear( $param )
    {
        $this->form->clear(TRUE);
    }
    
    /**
     * Load object to form data
     * @param $param Request
     */
    public function onEdit( $param )
    {
        try
        {
            if (isset($param['key']))
            {
                $key = $param['key'];  // get the parameter $key
                TTransaction::open('imobiliaria'); // open a transaction
                $object = new Imoveis($key); // instantiates the Active Record
                
                TScript::create('lat = ' . $object->latitude . ';lng = '. $object->longitude.';');//carrega a lat e lng atual 
            	TPage::include_js('https://maps.googleapis.com/maps/api/js?sensor=false&key=AIzaSyA4wqZZW7kw2wRh9PHIFjJdgLqVvoEXcUM&callback=initialize'); 
                
/*
                $Subcategorias = Subcategoria::where('id', '=', $object->subcategoria_id)->take(1)->load();                
                if ($Subcategorias[0])
                {
                    $categoria = $Subcategorias[0];
                    echo "a categoria  é: ".$categoria->id;
                    $filter = new TCriteria;
                    $filter->add(new TFilter('categoria_id', '=', $categoria->id));// seleciona o cadastrado no bd  
                }                
*/              
                  
                $object->opcionais = explode(',',$object->opcionais); 
                $object->agente = explode(',',$object->agente); 
                                
                $this->form->setData($object); // fill the form
                TTransaction::close(); // close the transaction
            }
            else
            {
                $this->form->clear(TRUE);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }
}
