<?php
/**
 * ImagensFormList Form List
 * @author  <your name here>
 */
class ImagensFormList extends TPage
{
    protected $form; // form
    protected $datagrid; // datagrid
    protected $pageNavigation;
    protected $loaded;
    
    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param )
    {
        parent::__construct($param);
        parent::setTargetContainer('adianti_right_panel');
        
        
        $this->form = new BootstrapFormBuilder('form_Imagens');
        $this->form->setFormTitle('Imagens');
        $this->form->setFieldSizes('100%');
        
        $parametro = TSession::getValue('parametro');
        if($parametro){
            $criteria = new TCriteria;
            $criteria->add(new TFilter('imoveis_id', '=', $parametro));
            $filter = new TCriteria;
            $filter->add(new TFilter('id', '=', $parametro));
        }
        else{
           throw new Exception( 'O campo "imoveis_id" não foi carregado');  
        }
            
            
        // create the form fields
        $id = new TEntry('id');
        //$imoveis_id = new TDBCombo('imoveis_id', 'imobiliaria', 'Imoveis', 'id', '{id} - {titulo}', 'id', $filter);
        $imoveis_id = new TDBCombo('imoveis_id', 'imobiliaria', 'Imoveis', 'id', '{id} - {titulo}', 'id', $filter);

        $nome = new TEntry('nome');
        $foto = new TSlim('foto');
        
        
        $imoveis_id->setDefaultOption(false);
        $foto->container->style = 'width:100%;height:150px;border:2px solid #A2A2A2;border-radius: 5px;';//tamanho do container do plugin no form
        $foto->setDataProperties(['label'=>'Upload Img imóveis']);
        $foto->setDataProperties(['size'=>'1500,1500']); 
        $foto->setDataProperties(['ratio'=>'95:48']);
        $foto->setDataProperties(['min-size'=>'450,200']);
        


        $row = $this->form->addFields( [ new TLabel('id'),     $id ],
                                       [ new TLabel('Imóvel'),  $imoveis_id ],
                                       [ new TLabel('Nome'), $nome ] );
        $row->layout = ['col-md-2', 'col-md-3', 'col-md-7' ];
        
        
        
        
        $row = $this->form->addFields( [ $foto ]);
        $row->layout = ['col-md-12' ];
        
        // add the fields
        //$this->form->addFields( [ new TLabel('Id') ], [ $id ], [ new TLabel('Imoveis ') ], [ $imoveis_id ], [ new TLabel('Nome') ], [ $nome ] );
        //$this->form->addFields( [ new TLabel('Foto') ], [ $foto ] );



        // set sizes
        //$id->setSize('50%');
        //$imoveis_id->setSize('50%');
        //$nome->setSize('100%');
        //$foto->setSize('100%');



        if (!empty($id))
        {
            $id->setEditable(FALSE);
        }
        if (!empty($imoveis_id))
        {
            $imoveis_id->setEditable(FALSE);
        }
        
        
        /** samples
         $fieldX->addValidation( 'Field X', new TRequiredValidator ); // add validation
         $fieldX->setSize( '100%' ); // set size
         **/
        
        // create the form actions
        $btn = $this->form->addAction(_t('Save'), new TAction([$this, 'onSave']), 'fa:save');
        $btn->class = 'btn btn-sm btn-primary';
        $this->form->addActionLink(_t('New'),  new TAction([$this, 'onEdit']), 'fa:eraser red');
        $this->form->addHeaderAction('Fechar', new TAction(array($this, 'onClose')), 'fa:window-close orange');
        
        // creates a Datagrid
        $this->datagrid = new BootstrapDatagridWrapper(new TDataGrid);
        $this->datagrid->style = 'width: 100%';
        // $this->datagrid->datatable = 'true';
        // $this->datagrid->enablePopover('Popover', 'Hi <b> {name} </b>');
        

        // creates the datagrid columns
        $column_id = new TDataGridColumn('id', 'Id', 'left');
        //$column_imoveis_id = new TDataGridColumn('imoveis_id', 'Imoveis ', 'left');
        $column_nome = new TDataGridColumn('nome', 'Nome', 'left');
        $column_foto = new TDataGridColumn('foto', 'Foto', 'left');


        // add the columns to the DataGrid
        $this->datagrid->addColumn($column_id);
        //$this->datagrid->addColumn($column_imoveis_id);
        $this->datagrid->addColumn($column_nome);
        $this->datagrid->addColumn($column_foto);
     
     
        //define the transformer method over image
        $column_foto->setTransformer( function($value, $object, $row) {
            if (file_exists($value)) {
                $imagem= new TImage($value); 
                $imagem->style='width:80px';//tamanho da imagem no grid
                return $imagem;
             } 
        });
        
        // creates two datagrid actions
        $action1 = new TDataGridAction([$this, 'onEdit']);
        //$action1->setUseButton(TRUE);
        //$action1->setButtonClass('btn btn-default');
        $action1->setLabel(_t('Edit'));
        $action1->setImage('far:edit blue');
        $action1->setField('id');
        
        $action2 = new TDataGridAction([$this, 'onDelete']);
        //$action2->setUseButton(TRUE);
        //$action2->setButtonClass('btn btn-default');
        $action2->setLabel(_t('Delete'));
        $action2->setImage('far:trash-alt red');
        $action2->setField('id');
        
        // add the actions to the datagrid
        $this->datagrid->addAction($action1);
        $this->datagrid->addAction($action2);
        
        // create the datagrid model
        $this->datagrid->createModel();
        
        // creates the page navigation
        $this->pageNavigation = new TPageNavigation;
        $this->pageNavigation->setAction(new TAction([$this, 'onReload']));
        $this->pageNavigation->setWidth($this->datagrid->getWidth());
        
        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        // $container->add(new TXMLBreadCrumb('menu.xml', __CLASS__));
        $container->add($this->form);
        $container->add(TPanelGroup::pack('', $this->datagrid, $this->pageNavigation));
        
        parent::add($container);
    }
    
    
    /**
     * on close
     */
    public static function onClose($param)
    {
        TScript::create("Template.closeRightPanel()");
    }
   
    /**
     * Load the datagrid with data
     */
    public function onReload($param = NULL)
    {
        try
        {
            // open a transaction with database 'imobiliaria'
            TTransaction::open('imobiliaria');
            
            // creates a repository for Imagens
            $repository = new TRepository('Imagens');
            $limit = 10;
            // creates a criteria
            $criteria = new TCriteria;
            
            
            $parametro   = TSession::getValue('parametro');
            if($parametro)
            {
                $criteria->add(new TFilter('imoveis_id', '=', $parametro));
            }
            
            // default order
            if (empty($param['order']))
            {
                $param['order'] = 'id';
                $param['direction'] = 'asc';
            }
            $criteria->setProperties($param); // order, offset
            $criteria->setProperty('limit', $limit);
            
            // load the objects according to criteria
            $objects = $repository->load($criteria, FALSE);
            
            $this->datagrid->clear();
            if ($objects)
            {
                // iterate the collection of active records
                foreach ($objects as $object)
                {
                    // add the object inside the datagrid
                    $this->datagrid->addItem($object);
                }
            }
            
            // reset the criteria for record count
            $criteria->resetProperties();
            $count= $repository->count($criteria);
            
            $this->pageNavigation->setCount($count); // count of records
            $this->pageNavigation->setProperties($param); // order, page
            $this->pageNavigation->setLimit($limit); // limit
            
            // close the transaction
            TTransaction::close();
            $this->loaded = true;
        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());
            
            // undo all pending operations
            TTransaction::rollback();
        }
    }
    
    /**
     * Ask before deletion
     */
    public static function onDelete($param)
    {
        // define the delete action
        $action = new TAction([__CLASS__, 'Delete']);
        $action->setParameters($param); // pass the key parameter ahead
        
        // shows a dialog to the user
        new TQuestion(AdiantiCoreTranslator::translate('Do you really want to delete ?'), $action);
    }
    
    /**
     * Delete a record
     */
    public static function Delete($param)
    {
        try
        {
            $key = $param['key']; // get the parameter $key
            TTransaction::open('imobiliaria'); // open a transaction with database
            $object = new Imagens($key, FALSE); // instantiates the Active Record
           

            if( file_exists ( $object->foto))//apaga a  imagem            
            {
               unlink($object->foto);
            } 
            
            //funcoes::apagaminiatura($object->foto, 'assets/img/interiores/');   
            
             $object->delete(); // deletes the object from the database
            
            TTransaction::close(); // close the transaction
            
            $pos_action = new TAction([__CLASS__, 'onReload']);
            new TMessage('info', AdiantiCoreTranslator::translate('Record deleted'), $pos_action); // success message
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }
    
    /**
     * Save form data
     * @param $param Request
     */
    public function onSave( $param )
    {
        try
        {
            TTransaction::open('imobiliaria'); // open a transaction
            
            /**
            // Enable Debug logger for SQL operations inside the transaction
            TTransaction::setLogger(new TLoggerSTD); // standard output
            TTransaction::setLogger(new TLoggerTXT('log.txt')); // file
            **/
            
            $this->form->validate(); // validate form data
            $data = $this->form->getData(); // get form data as array
            
            $object = new Imagens;  // create an empty object
            $object->fromArray( (array) $data); // load the object with data
            
            
            $images = Slim::getImages();            
           
            $object2 = new Imagens($object->id); //objeto criado para testar se imagem foi repetida  

            
            if ($images) {

                         
               $image = $images[0];
               // save output data if set
               if (isset($image['output']['data']))
               {
                  // Save the file
                  $name = $image['output']['name'];  
                  
                  $ext = pathinfo($name, PATHINFO_EXTENSION);                  
                  $texto = substr($name, 0, -3);
                  $texto = funcoes::name($texto);
        
                  // We'll use the output crop data                  
                  $datas = $image['output']['data'];  
                   
                  if($datas != null){
                     //salva o arquivo na pasta concatenado o nome com o tempo e o formato    
                     $output = Slim::saveFile($datas, $texto.'-'.time().'.'.$ext, 'assets/img/interiores/', false);

                  } 
                  
                  //edição de registro
                  if( $object2->foto !=  $output )//se a imagem salva no banco for diferente da imagem slim
                  {
                     if( file_exists ($object2->foto))// se existir apaga o anterior
                     {
                        unlink( $object2->foto ); //apaga
                     }                   
                  } 
                                                    
                  $object->foto = $output['path'];//recebe o caminho para salvar

               }
            }
            else{
               
               $object->foto = $object2->foto;
            }
            

            if(empty($object->foto)) {//primeiro registro
            
                throw new Exception( 'O campo "FOTO" é obrigatório');  
                   
            }      
            
            
            
            $object->store(); // save the object
            
            // get the generated id
            $data->id = $object->id;
            $data->foto = $object->foto;
            
            $this->form->setData($data); // fill form data
            TTransaction::close(); // close the transaction
            
            new TMessage('info', AdiantiCoreTranslator::translate('Record saved')); // success message
            $this->onReload(); // reload the listing
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            $this->form->setData( $this->form->getData() ); // keep form data
            TTransaction::rollback(); // undo all pending operations
        }
    }
    
    /**
     * Clear form data
     * @param $param Request
     */
    public function onClear( $param )
    {
        $this->form->clear(TRUE);
    }
    
    /**
     * Load object to form data
     * @param $param Request
     */
    public function onEdit( $param )
    {
        try
        {
            if (isset($param['key']))
            {
                $key = $param['key'];  // get the parameter $key
                TTransaction::open('imobiliaria'); // open a transaction
                $object = new Imagens($key); // instantiates the Active Record
                $this->form->setData($object); // fill the form
                TTransaction::close(); // close the transaction
            }
            else
            {
                $this->form->clear(TRUE);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }
    
    /**
     * method show()
     * Shows the page
     */
    public function show()
    {
        // check if the datagrid is already loaded
        if (!$this->loaded AND (!isset($_GET['method']) OR $_GET['method'] !== 'onReload') )
        {
            $this->onReload( func_get_arg(0) );
        }
        parent::show();
    }
}
