<?php
/**
 * ImagensForm Master/Detail
 * @author  <your name here>
 */
class ImagensForm extends TPage
{
    protected $form;
    protected $fieldlist;
    
    /**
     * Class constructor
     * Creates the page and the registration form
     */
    function __construct($param)
    {
        parent::__construct($param);
        
        parent::setTargetContainer('adianti_right_panel');

        // creates the form
        $this->form = new BootstrapFormBuilder('form_Imagens');
        $this->form->setFormTitle('Imagens');
        
        $this->fieldlist = new TFieldList;
        $this->fieldlist->width = '100%';
        $this->fieldlist->enableSorting();
        
        // add field list to the form
        $this->form->addContent( [$this->fieldlist] );
        
        $id = new TEntry('list_id[]');
        $imoveis_id = new TDBCombo('list_imoveis_id[]', 'imobiliaria', 'Imoveis', 'id', 'titulo');
        $nome = new TEntry('list_nome[]');
        $foto = new TSlim('list_foto[]');

        $id->setSize('50%');
        $imoveis_id->setSize('50%');
        $nome->setSize('100%');
        $foto->setSize('100%');

        $espaco = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        $this->fieldlist->addField( '<b>Id</b>', $id);
        $this->fieldlist->addField( '<b>Imoveis Id</b>', $imoveis_id);
        $this->fieldlist->addField( '<b>Nome</b>', $nome);
        $this->fieldlist->addField( '<b>Foto</b>'.$espaco.$espaco, $foto);
        
        $foto->container->style = 'width:100%;height:65px;border:2px solid #A2A2A2;border-radius: 5px;';//tamanho do container do plugin no form
        $foto->setDataProperties(['label'=>'add']);
        z$foto->setDataProperties(['ratio'=>'1:1']); 


        $this->form->addField($id);
        $this->form->addField($imoveis_id);
        $this->form->addField($nome);
        $this->form->addField($foto);
        
        $this->fieldlist->addHeader();
        $this->fieldlist->addDetail( new stdClass );
        $this->fieldlist->addDetail( new stdClass );

        $this->fieldlist->addCloneAction();
        
        // create an action button (save)
        $this->form->addAction( 'Save', new TAction([$this, 'onSave']), 'fa:save blue');
        $this->form->addHeaderAction('Send', new TAction(array($this, 'onClose')), 'fa:rocket orange');

        
        // create the page container
        $container = new TVBox;
        $container->style = 'width: 100%';
        //$container->add(new TXMLBreadCrumb('menu.xml', __CLASS__));
        $container->add($this->form);
        
        parent::add($container);
    }
    
     /**
     * on close
     */
    public static function onClose($param)
    {
        TScript::create("Template.closeRightPanel()");
    }
    
   
    /**
     * Clear form
     */
    public function onClear($param)
    {
    }
    
    /**
     * Save the Imagens
     */
    public static function onSave($param)
    {
        try
        {
            TTransaction::open('imobiliaria');
            
            if( !empty($param['list_id']) AND is_array($param['list_id']) )
            {
                foreach( $param['list_id'] as $row => $id)
                {
                    if (!empty($id))
                    {
                        $detail = new Imagens;
                        $detail->id = $param['list_id'][$row];
                        $detail->imoveis_id = $param['list_imoveis_id'][$row];
                        $detail->nome = $param['list_nome'][$row];
                        
                        
                        
                        $images = Slim::getImages();            
           
                        $object2 = new Depoimentos($object->id); //objeto criado para testar se imagem foi repetida 
                        
                        if ($images) {
                                     
                           $image = $images[0];
                           // save output data if set
                           if (isset($image['output']['data']))
                           {
                              // Save the file
                              $name = $image['output']['name'];  
                              
                              $ext = pathinfo($name, PATHINFO_EXTENSION);                  
                              $texto = substr($name, 0, -3);
                              $texto = funcoes::name($texto);             
                    
                              // We'll use the output crop data                  
                              $datas = $image['output']['data'];  
                               
                              if($datas != null){
                                 //salva o arquivo na pasta img/depoimentos concatenado o nome com o tempo e o formato    
                                 $output = Slim::saveFile($datas, $texto.'-'.time().'.'.$ext, 'assets/img/interiores/', false);
                              } 
                              
                              if( $object2->foto !=  $output )//se a imagem do banco for diferente da imagem slim
                              {
                                 if( file_exists ($object2->foto))// se existir apaga o anterior
                                 {
                                    unlink( $object2->foto ); //apaga
                                 }                   
                              } 
                            
                              $object->foto = $output['path'];//recebe o caminho para salvar
                              
                           }
                        }
                        else{
                                       
                           $object->foto = $object2->foto;
                           
                        }            
                        
                        if(empty($object->foto)) {//primeiro registro
                        
                            throw new Exception( 'O campo "FOTO" é obrigatório'); 
                                                
                        }                       
                        
                        
                        $detail->store();
                    }
                }
            }
            
            TTransaction::close(); // close the transaction
            
            new TMessage('info', AdiantiCoreTranslator::translate('Record saved'));
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }
    
    
}
