<?php
/**
 * FaqForm Registration
 * @author  <your name here>
 */
class FaqForm extends TPage
{
    protected $form; // form
    
    use Adianti\Base\AdiantiStandardFormTrait; // Standard form methods
    
    /**
     * Class constructor
     * Creates the page and the registration form
     */
    function __construct()
    {
        parent::__construct();
        
        
        $this->setDatabase('imobiliaria');              // defines the database
        $this->setActiveRecord('Faq');     // defines the active record
        
        // creates the form
        $this->form = new BootstrapFormBuilder('form_Faq');
        $this->form->setFormTitle('Faq');
        

        // create the form fields
        $id = new TEntry('id');
        $titulo = new TEntry('titulo');
        $texto = new TText('texto');


        // add the fields
        $this->form->addFields( [ new TLabel('Id') ], [ $id ] );
        $this->form->addFields( [ new TLabel('Titulo') ], [ $titulo ] );
        $this->form->addFields( [ new TLabel('Texto') ], [ $texto ] );



        // set sizes
        $id->setSize('100%');
        $texto->setSize('100%');


        
        if (!empty($id))
        {
            $id->setEditable(FALSE);
        }
        
        /** samples
         $fieldX->addValidation( 'Field X', new TRequiredValidator ); // add validation
         $fieldX->setSize( '100%' ); // set size
         **/
         
        // create the form actions
        $btn = $this->form->addAction(_t('Save'), new TAction([$this, 'onSave']), 'fa:save');
        $btn->class = 'btn btn-sm btn-primary';
        $btn2= $this->form->addActionLink(_t('New'),  new TAction([$this, 'onEdit']), 'fa:eraser red');          
        $btn3 =  $this->form->addAction('Voltar',  new TAction(['FaqList', 'onReload']) , 'fa:table blue fa-3x');
        
                         
        $btn->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px';
        $btn2->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px';
        $btn3->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px'; 
        
        
        
        
        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        // $container->add(new TXMLBreadCrumb('menu.xml', __CLASS__));
        $container->add($this->form);
        
        parent::add($container);
    }
}
