<?php
/**
 * DepoimentosForm Form
 * @author  <your name here>
 */
class DepoimentosForm extends TPage
{
    protected $form; // form
    
    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param )
    {
        parent::__construct();
        
        //TWindow::setSize(700,500);
        //TWindow::setTitle("testando");
        // creates the form
        $this->form = new BootstrapFormBuilder('form_Depoimentos');
        $this->form->setFormTitle('Formulário de Depoimentos');
        

        // create the form fields
        $id = new THidden('id');
        $nome = new TEntry('nome');
        $msg = new TEntry('msg');
        $foto = new TSlim('foto');
        $status = new TCombo('status');
        $status->addItems(array('S'=> 'Ativo', 'N'=> 'Inativo'));
        
        
        $foto->container->style = 'width:80%;height:175px;border:2px solid #A2A2A2;border-radius: 10px;';//tamanho do container do plugin no form
        $foto->setDataProperties(['label'=>'Foto Depoimento']);
        $foto->setDataProperties(['ratio'=>'1:1']); 
        //$foto->setDataProperties(['will-transform'=>'addWatermark']); 
        //self::Criamarcadagua("teste");  
        


        // add the fields
        $this->form->addFields( [ new THidden('Id:') ], [ $id ] );
        $this->form->addFields( [ new TLabel('Status:<font color="red">*</font>') ], [ $status ], [ new TLabel('Nome:<font color="red">*</font>') ], [ $nome ] );        
        $this->form->addFields( [ new TLabel('Msg:<font color="red">*</font>') ], [ $msg ] );
        $this->form->addFields( [ new TLabel('Foto:<font color="red">*</font>') ], [ $foto ] );
        
                

        $nome->addValidation('Nome', new TRequiredValidator);
        $msg->addValidation('Msg', new TRequiredValidator);
        //$foto->addValidation('Foto', new TRequiredValidator);
        $status->addValidation('Status', new TRequiredValidator);


        // set sizes
        $id->setSize('100%');
        $nome->setSize('100%');
        $msg->setSize('100%');
        $foto->setSize('100%');
        $status->setSize('100%');



        if (!empty($id))
        {
            $id->setEditable(FALSE);
        }
        
        /** samples
         $fieldX->addValidation( 'Field X', new TRequiredValidator ); // add validation
         $fieldX->setSize( '100%' ); // set size
         **/
         
        // create the form actions
        $btn = $this->form->addAction(_t('Save'), new TAction([$this, 'onSave']), 'fa:save');
        $btn->class = 'btn btn-sm btn-primary';
        $btn2= $this->form->addActionLink(_t('New'),  new TAction([$this, 'onEdit']), 'fa:eraser red');          
        $btn3 =  $this->form->addAction('Voltar',  new TAction(['DepoimentosList', 'onReload']) , 'fa:table blue fa-3x');
        
        
        $btn->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px';
        $btn2->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px';
        $btn3->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px'; 
        
        
        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        // $container->add(new TXMLBreadCrumb('menu.xml', __CLASS__));
        $container->add($this->form);
        
        parent::add($container);
    }

    /**
     * Save form data
     * @param $param Request
     */
    public function onSave( $param )
    {
        try
        {
            TTransaction::open('imobiliaria'); // open a transaction
            
            /**
            // Enable Debug logger for SQL operations inside the transaction
            TTransaction::setLogger(new TLoggerSTD); // standard output
            TTransaction::setLogger(new TLoggerTXT('log.txt')); // file
            **/
            
            $this->form->validate(); // validate form data            
            $data = $this->form->getData(); // get form data as array
            
            $object = new Depoimentos;  // create an empty object            
            $object->fromArray( (array) $data); // load the object with data             
            
            $images = Slim::getImages();            
           
            $object2 = new Depoimentos($object->id); //objeto criado para testar se imagem foi repetida 
            
            if ($images) {
                         
               $image = $images[0];
               // save output data if set
               if (isset($image['output']['data']))
               {
                  // Save the file
                  $name = $image['output']['name'];  
                  
                  $ext = pathinfo($name, PATHINFO_EXTENSION);                  
                  $texto = substr($name, 0, -3);
                  $texto = funcoes::name($texto);             
        
                  // We'll use the output crop data                  
                  $datas = $image['output']['data'];  
                   
                  if($datas != null){
                     //salva o arquivo na pasta img/depoimentos concatenado o nome com o tempo e o formato    
                     $output = Slim::saveFile($datas, $texto.'-'.time().'.'.$ext, 'assets/img/depoimentos/', false);
                  } 
                  
                  if( $object2->foto !=  $output )//se a imagem do banco for diferente da imagem slim
                  {
                     if( file_exists ($object2->foto))// se existir apaga o anterior
                     {
                        unlink( $object2->foto ); //apaga
                     }                   
                  } 
                
                  $object->foto = $output['path'];//recebe o caminho para salvar
                  
               }
            }
            else{
                           
               $object->foto = $object2->foto;
               
            }            
            
            if(empty($object->foto)) {//primeiro registro
            
                throw new Exception( 'O campo "FOTO" é obrigatório'); 
                                    
            }
            
            $object->store(); // save the object
            
            // get the generated id
            $data->id = $object->id;
            
            $this->form->setData($data); // fill form data
            TTransaction::close(); // close the transaction
            
            //new TMessage('info', AdiantiCoreTranslator::translate('Record saved'));
            new TMessage('info', TAdiantiCoreTranslator::translate('Record saved'), new TAction(['DepoimentosList', 'onReload'] ) );
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            $this->form->setData( $this->form->getData() ); // keep form data
            TTransaction::rollback(); // undo all pending operations
        }
    }
    
    /**
     * Clear form data
     * @param $param Request
     */
    public function onClear( $param )
    {
        $this->form->clear(TRUE);
    }
    
    /**
     * Load object to form data
     * @param $param Request
     */
    public function onEdit( $param )
    {
        try
        {
            if (isset($param['key']))
            {
                $key = $param['key'];  // get the parameter $key
                TTransaction::open('imobiliaria'); // open a transaction
                $object = new Depoimentos($key); // instantiates the Active Record
                $this->form->setData($object); // fill the form
                TTransaction::close(); // close the transaction
            }
            else
            {
                $this->form->clear(TRUE);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }
}
