<?php
/**
 * ContratoForm Form
 * @author  <your name here>
 */
class ContratoForm extends TPage
{
    protected $form; // form
    
    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param )
    {
        parent::__construct();
        
        
        // creates the form
        $this->form = new BootstrapFormBuilder('form_Contrato');
        $this->form->setFormTitle('Contrato');
        

        // create the form fields
        $id = new TEntry('id');
        $nome = new TEntry('nome');
        $contrato = new TFile('contrato');
        $imoveis_id = new TDBCombo('imoveis_id', 'imobiliaria', 'Imoveis', 'id', '{id} - {titulo}' ,'id asc');




        // add the fields
        $this->form->addFields( [ new TLabel('Id') ], [ $id ] );
        $this->form->addFields( [ new TLabel('Nome') ], [ $nome ] );
        $this->form->addFields( [ new TLabel('Contrato') ], [ $contrato ] );
        $this->form->addFields( [ new TLabel('Imoveis Id') ], [ $imoveis_id ] );

        $nome->addValidation('Nome', new TRequiredValidator);
        $contrato->addValidation('Contrato', new TRequiredValidator);


        $contrato->setAllowedExtensions( ['pdf', 'doc', 'docx'] );

        // set sizes
        $id->setSize('100%');
        $nome->setSize('100%');
        $contrato->setSize('100%');
        $imoveis_id->setSize('100%');



        if (!empty($id))
        {
            $id->setEditable(FALSE);
        }
        
        /** samples
         $fieldX->addValidation( 'Field X', new TRequiredValidator ); // add validation
         $fieldX->setSize( '100%' ); // set size
         **/
         
        // create the form actions
        $btn = $this->form->addAction(_t('Save'), new TAction([$this, 'onSave']), 'fa:save');
        $btn->class = 'btn btn-sm btn-primary';
        $this->form->addActionLink(_t('New'),  new TAction([$this, 'onEdit']), 'fa:eraser red');
        
        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        // $container->add(new TXMLBreadCrumb('menu.xml', __CLASS__));
        $container->add($this->form);
        
        parent::add($container);
    }

    /**
     * Save form data
     * @param $param Request
     */
    public function onSave( $param )
    {
        try
        {
            var_dump($param);
            
            TTransaction::open('imobiliaria'); // open a transaction
            
            /**
            // Enable Debug logger for SQL operations inside the transaction
            TTransaction::setLogger(new TLoggerSTD); // standard output
            TTransaction::setLogger(new TLoggerTXT('log.txt')); // file
            **/
            
            $this->form->validate(); // validate form data
            $data = $this->form->getData(); // get form data as array
            
            $object = new Contrato;  // create an empty object
            $object->fromArray( (array) $data); // load the object with data
            
/*
            $source_file   = 'tmp/'.$param['contrato'];

            var_dump($source_file);
            $target_path   = 'assets/contrato/';
            $target_file   =  $target_path .'/'. $param['nome'].'/';

            
            if (file_exists($source_file))
            {
                if (!file_exists($target_path))
                {
                    if (!mkdir($target_path, 0777, true))
                    {
                        throw new Exception(_t('Permission denied'). ': '. $target_path);
                    }
                }
                else
                {                                        
                    foreach (glob("$target_path/*") as $file)

                    {
                        unlink($file);
                    }
                }
                
                // if the user uploaded a source file
                if (file_exists($target_path))
                {
                    // move to the target directory
                    rename($source_file, $target_file);
                    
                }
            }
*/            
            
            $source_file   = 'tmp/'.TSession::getValue('system_document_upload_file');
            $target_path   = 'assets/contrato/' . $object->id;
            $target_file   =  $target_path . '/'.$object->nome;
            
            if (file_exists($source_file))
            {
                if (!file_exists($target_path))
                {
                    if (!mkdir($target_path, 0777, true))
                    {
                        throw new Exception(_t('Permission denied'). ': '. $target_path);
                    }
                }
                
                
                // if the user uploaded a source file
                if (file_exists($target_path))
                {
                    // move to the target directory
                    rename($source_file, $target_file);
                }
                
                $files = glob('tmp/*'); //get all file names
                    foreach($files as $file){
                        if(is_file($file))
                        unlink($file); //delete file
                    } 
            }
            
            
            
       
       
            $object->store(); // save the object
            
            // get the generated id
            $data->id = $object->id;
            
            $this->form->setData($data); // fill form data
            TTransaction::close(); // close the transaction
            
            new TMessage('info', AdiantiCoreTranslator::translate('Record saved'));
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            $this->form->setData( $this->form->getData() ); // keep form data
            TTransaction::rollback(); // undo all pending operations
        }
    }
    
    /**
     * Clear form data
     * @param $param Request
     */
    public function onClear( $param )
    {
        $this->form->clear(TRUE);
    }
    
    /**
     * Load object to form data
     * @param $param Request
     */
    public function onEdit( $param )
    {
        try
        {
            if (isset($param['key']))
            {
                $key = $param['key'];  // get the parameter $key
                TTransaction::open('imobiliaria'); // open a transaction
                $object = new Contrato($key); // instantiates the Active Record
                $this->form->setData($object); // fill the form
                TTransaction::close(); // close the transaction
            }
            else
            {
                $this->form->clear(TRUE);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }
}
