<?php
/**
 * ClientesImoveisFormView Master/Detail
 * @author  <your name here>
 */
class ClientesImoveisFormView extends TPage
{
    protected $form; // form
    protected $detail_list;
    
    /**
     * Page constructor
     */
    public function __construct($param)
    {
        parent::__construct();
        
        
        $this->form = new BootstrapFormBuilder('form_ClientesView');
        $this->form->setFormTitle('Clientes');
        // $this->form->addHeaderActionLink('Editar', new TAction(['ClientesForm', 'onEdit'],['key'=>$param['id']]), 'far:edit blue');
        
        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%'; 
        // $container->add(new TXMLBreadCrumb('menu.xml', 'ClientesList'));
        $container->add($this->form);

        parent::add($container);
    }
    
    /**
     * onEdit
     */
    public function onEdit($param)
    {
        try
        {
            TTransaction::open('imobiliaria');
            $master_object = new Clientes($param['key']);
            
            $label_id = new TLabel('Id:', '#333333', '12px', '');
            $label_nome = new TLabel('Nome:', '#333333', '12px', '');
            $label_datacad = new TLabel('Datacad:', '#333333', '12px', '');
            $label_foto = new TLabel('Foto:', '#333333', '12px', '');
            $label_fone = new TLabel('Fone:', '#333333', '12px', '');
            $label_endereco = new TLabel('Endereco:', '#333333', '12px', '');

            $text_id  = new TTextDisplay($master_object->id, '#333333', '12px', '');
            $text_nome  = new TTextDisplay($master_object->nome, '#333333', '12px', '');
            $text_datacad  = new TTextDisplay($master_object->datacad, '#333333', '12px', '');
            $text_foto  = new TTextDisplay($master_object->foto, '#333333', '12px', '');
            $text_fone  = new TTextDisplay($master_object->fone, '#333333', '12px', '');
            $text_endereco  = new TTextDisplay($master_object->endereco, '#333333', '12px', '');

            $this->form->addFields([$label_id],[$text_id]);
            $this->form->addFields([$label_nome],[$text_nome]);
            $this->form->addFields([$label_datacad],[$text_datacad]);
            $this->form->addFields([$label_foto],[$text_foto]);
            $this->form->addFields([$label_fone],[$text_fone]);
            $this->form->addFields([$label_endereco],[$text_endereco]);
            
            $this->detail_list = new BootstrapDatagridWrapper( new TDataGrid );
            $this->detail_list->style = 'width:100%';
            $this->detail_list->disableDefaultClick();
            
            $this->detail_list->addColumn( new TDataGridColumn('clientes_id', 'Clientes Id', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('titulo', 'Titulo', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('valor', 'Valor', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('quartos', 'Quartos', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('area', 'Area', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('suites', 'Suites', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('garagens', 'Garagens', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('banheiros', 'Banheiros', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('areaedificada', 'Areaedificada', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('opcionais', 'Opcionais', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('areaconstruida', 'Areaconstruida', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('bairro_id', 'Bairro Id', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('endereco', 'Endereco', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('foto', 'Foto', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('status', 'Status', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('pagina', 'Pagina', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('latitude', 'Latitude', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('longitude', 'Longitude', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('video', 'Video', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('agente', 'Agente', 'left') );
            $this->detail_list->addColumn( new TDataGridColumn('descricao', 'Descricao', 'left') );
            
            $this->detail_list->createModel();
            
            $items = Imoveis::where('subcategoria_id', '=', $master_object->id)->load();
            $this->detail_list->addItems($items);
            
            $panel = new TPanelGroup('Itens', '#f5f5f5');
            $panel->add($this->detail_list);
            
            $this->form->addContent([$panel]);
            
            TTransaction::close();
        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    }
}
