<?php
/**
 * CategoriaList Listing
 * @author  <your name here>
 */
class CategoriaList extends TPage
{
    protected $form;     // registration form
    protected $datagrid; // listing
    protected $pageNavigation;
    protected $formgrid;
    protected $deleteButton;
    
    use Adianti\base\AdiantiStandardListTrait;
    
    /**
     * Page constructor
     */
    public function __construct()
    {
        parent::__construct();
        
        $this->setDatabase('imobiliaria');            // defines the database
        $this->setActiveRecord('Categoria');   // defines the active record
        $this->setDefaultOrder('id', 'asc');         // defines the default order
        $this->setLimit(10);
        // $this->setCriteria($criteria) // define a standard filter


        $this->addFilterField('nome', 'like', 'nome'); // filterField, operator, formField
        $this->addFilterField('slug', 'like', 'slug'); // filterField, operator, formField
        $this->addFilterField('corfundo', 'like', 'corfundo'); // filterField, operator, formField
        $this->addFilterField('corfundohover', 'like', 'corfundohover'); // filterField, operator, formField
        $this->addFilterField('ordem', 'like', 'ordem'); // filterField, operator, formField
        
        // creates the form
        $this->form = new BootstrapFormBuilder('form_search_Categoria');
        $this->form->setFormTitle('Lista Categorias');
        

        // create the form fields
        $id = new THidden('id');
        $nome = new TEntry('nome');
        $slug = new TEntry('slug');
        $corfundo = new TEntry('corfundo');
        $corfundohover = new THidden('corfundohover');
        $ordem = new TEntry('ordem');


        // add the fields

        $this->form->addFields( [ new TLabel('Nome:') ], [ $nome ] , [ new TLabel('Slug:') ], [ $slug ] );
        $this->form->addFields( [ new TLabel('Cor fundo:') ], [ $corfundo ] , [ new TLabel('Ordem:') ], [ $ordem ] );


        // set sizes
        $id->setSize('100%');
        $nome->setSize('100%');
        $slug->setSize('100%');
        $corfundo->setSize('100%');
        $corfundohover->setSize('100%');
        $ordem->setSize('100%');

        
        // keep the form filled during navigation with session data
        $this->form->setData( TSession::getValue(__CLASS__.'_filter_data') );
        
        // add the search form actions
        $btn = $this->form->addAction(_t('Find'), new TAction([$this, 'onSearch']), 'fa:search');
        $btn->class = 'btn btn-sm btn-primary';
        $btn2 = $this->form->addActionLink(_t('New'), new TAction(['CategoriaForm', 'onEdit']), 'fa:plus green');
        
        $btn->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px';
        $btn2->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px';
        
        // creates a Datagrid
        $this->datagrid = new BootstrapDatagridWrapper(new TDataGrid);
        $this->datagrid->style = 'width: 100%';
        $this->datagrid->datatable = 'true';
        // $this->datagrid->enablePopover('Popover', 'Hi <b> {name} </b>');
        

        // creates the datagrid columns
        $column_id = new TDataGridColumn('id', 'Id', 'right');
        $column_nome = new TDataGridColumn('nome', 'Nome', 'left');
        $column_slug = new TDataGridColumn('slug', 'Slug', 'left');
        $column_corfundo = new TDataGridColumn('corfundo', 'Cor fundo', 'left');
        $column_ordem = new TDataGridColumn('ordem', 'Ordem', 'right');


        // add the columns to the DataGrid
        $this->datagrid->addColumn($column_id);
        $this->datagrid->addColumn($column_nome);
        $this->datagrid->addColumn($column_slug);
        $this->datagrid->addColumn($column_corfundo);
        $this->datagrid->addColumn($column_ordem);


        // creates the datagrid column actions
        $column_nome->setAction(new TAction([$this, 'onReload']), ['order' => 'nome']);

        
        $action1 = new TDataGridAction(['CategoriaForm', 'onEdit'], ['id'=>'{id}']);
        $action2 = new TDataGridAction([$this, 'onDelete'], ['id'=>'{id}']);
        
        $this->datagrid->addAction($action1, _t('Edit'),   'far:edit blue');
        $this->datagrid->addAction($action2 ,_t('Delete'), 'far:trash-alt red');
        
        // create the datagrid model
        $this->datagrid->createModel();
        
        // creates the page navigation
        $this->pageNavigation = new TPageNavigation;
        $this->pageNavigation->setAction(new TAction([$this, 'onReload']));
        
        $panel = new TPanelGroup('', 'white');
        $panel->add($this->datagrid);
        $panel->addFooter($this->pageNavigation);
        
        // header actions
        $dropdown = new TDropDown(_t('Export'), 'fa:list');
        $dropdown->setPullSide('right');
        $dropdown->setButtonClass('btn btn-default waves-effect dropdown-toggle');
        $dropdown->addAction( _t('Save as CSV'), new TAction([$this, 'onExportCSV'], ['register_state' => 'false', 'static'=>'1']), 'fa:table blue' );
        $dropdown->addAction( _t('Save as PDF'), new TAction([$this, 'onExportPDF'], ['register_state' => 'false', 'static'=>'1']), 'far:file-pdf red' );
        $panel->addHeaderWidget( $dropdown );
        
        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        // $container->add(new TXMLBreadCrumb('menu.xml', __CLASS__));
        $container->add($this->form);
        $container->add($panel);
        
        parent::add($container);
    }
}
