<?php
/**
 * CategoriaForm Form
 * @author  <your name here>
 */
class CategoriaForm extends TPage
{
    protected $form; // form
    
    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param )
    {
        parent::__construct();
        
        
        // creates the form
        $this->form = new BootstrapFormBuilder('form_Categoria');
        $this->form->setFormTitle('Form Categorias');
        

        // create the form fields
        $id = new THidden('id');
        $nome = new TEntry('nome');
        $slug = new TEntry('slug');
        $ordem = new TEntry('ordem');
        $corfundo = new TColor('corfundo');
        $corfundohover = new TColor('corfundohover');
        
        $ordem->setMask('99');


        // add the fields
        $this->form->addFields( [ $id ] );
        $this->form->addFields( [ new TLabel('Nome:') ], [ $nome ] , [ new TLabel('Slug:') ], [ $slug ] );
        $this->form->addFields( [ new TLabel('Ordem:') ], [ $ordem ] ,[ new TLabel('Cor fundo:') ], [ $corfundo ] , [ new TLabel('Cor hover:') ], [ $corfundohover ] );



        // set sizes
        $id->setSize('100%');
        $nome->setSize('100%');
        $slug->setSize('100%');
        $ordem->setSize('100%');
        $corfundo->setSize('100%');
        $corfundohover->setSize('100%');



        if (!empty($id))
        {
            $id->setEditable(FALSE);
        }
        if (!empty($slug))
        {
            $slug->setEditable(FALSE);
        }
        
        /** samples
         $fieldX->addValidation( 'Field X', new TRequiredValidator ); // add validation
         $fieldX->setSize( '100%' ); // set size
         **/
         
        // create the form actions
        $btn = $this->form->addAction(_t('Save'), new TAction([$this, 'onSave']), 'fa:save');
        $btn->class = 'btn btn-sm btn-primary';
        $btn2 =  $this->form->addActionLink(_t('New'), new TAction([$this, 'onEdit']), 'fa:eraser red');
        $btn3 =  $this->form->addAction('Voltar',  new TAction(['CategoriaList', 'onReload']) , 'fa:table blue fa-3x');
        
        $btn->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px';
        $btn2->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px';
        $btn3->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px'; 

         
        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        // $container->add(new TXMLBreadCrumb('menu.xml', __CLASS__));
        $container->add($this->form);
        
        parent::add($container);
    }

    /**
     * Save form data
     * @param $param Request
     */
    public function onSave( $param )
    {
        try
        {
            TTransaction::open('imobiliaria'); // open a transaction
            
            /**
            // Enable Debug logger for SQL operations inside the transaction
            TTransaction::setLogger(new TLoggerSTD); // standard output
            TTransaction::setLogger(new TLoggerTXT('log.txt')); // file
            **/
            
            $this->form->validate(); // validate form data
            $data = $this->form->getData(); // get form data as array
            
            $object = new Categoria;  // create an empty object
            $object->fromArray( (array) $data); // load the object with data
            
            if($object->nome)
            {   
              $object->slug = funcoes::url_amigavel($object->nome);           
            }
            
            $object->store(); // save the object
            
            // get the generated id
            $data->id = $object->id;
            
            $this->form->setData($data); // fill form data
            TTransaction::close(); // close the transaction            

            new TMessage('info', TAdiantiCoreTranslator::translate('Record saved'), new TAction(['CategoriaList', 'onReload'] ) );
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            $this->form->setData( $this->form->getData() ); // keep form data
            TTransaction::rollback(); // undo all pending operations
        }
    }
    
    /**
     * Clear form data
     * @param $param Request
     */
    public function onClear( $param )
    {
        $this->form->clear(TRUE);
    }
    
    /**
     * Load object to form data
     * @param $param Request
     */
    public function onEdit( $param )
    {
        try
        {
            if (isset($param['key']))
            {
                $key = $param['key'];  // get the parameter $key
                TTransaction::open('imobiliaria'); // open a transaction
                $object = new Categoria($key); // instantiates the Active Record
                $this->form->setData($object); // fill the form
                TTransaction::close(); // close the transaction
            }
            else
            {
                $this->form->clear(TRUE);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }
     
}
