<?php
/**
 * BannersFormList Form List
 * @author  <your name here>
 */
class BannersFormList extends TPage
{
    protected $form; // form
    protected $datagrid; // datagrid
    protected $pageNavigation;
    protected $loaded;
    
    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param )
    {
        parent::__construct();
        
        
        $this->form = new BootstrapFormBuilder('form_Banners');
        $this->form->setFormTitle('Banners');


        // create the form fields
        $id      = new TEntry('id');
        $imagem  = new TSlim('imagem');
        $alt     = new TEntry('alt');
        $link    = new TEntry('link');
        $linkimg = new TEntry('linkimg');
        

        $imagem->container->style = 'width:100%;height:240px;border:2px solid #A2A2A2;border-radius: 10px;';//tamanho do container do plugin no form
        $imagem->setDataProperties(['label'=>'Upload banner']);
        $imagem->setDataProperties(['ratio'=>'8:4']);       
        //$imagem->setDataProperties(['will-transform'=>'addWatermark']); 
        //self::Criamarcadagua("teste");  
        

        // add the fields
        $this->form->addFields( [ new TLabel('Id:') ], [ $id ] , [ new TLabel('Nome:<font color="red">*</font>') ], [ $alt ] );
        $this->form->addFields( [ new TLabel('Link:') ], [ $link ] , [ new TLabel('Url Img:') ], [ $linkimg ] );
        $this->form->addFields( [ new TLabel('Imagem:<font color="red">*</font>') ], [ $imagem ] );


        $alt->addValidation('Nome', new TRequiredValidator);
        
        
        // set sizes
        $id->setSize('100%');
        $imagem->setSize('100%');
        $alt->setSize('100%');
        $link->setSize('100%');
        $linkimg->setSize('100%');



        if (!empty($id))
        {
            $id->setEditable(FALSE);
        }
        
        
        
        /** samples
         $fieldX->addValidation( 'Field X', new TRequiredValidator ); // add validation
         $fieldX->setSize( '100%' ); // set size
         **/
        
        // create the form actions
        $btn = $this->form->addAction(_t('Save'), new TAction([$this, 'onSave']), 'fa:save');
        $btn->class = 'btn btn-sm btn-primary';
        $btn2 =  $this->form->addActionLink(_t('New'), new TAction([$this, 'onEdit']), 'fa:eraser red');
        
        $btn->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px';
        $btn2->style = 'font-size:16px;width:160px;height:50px; padding:10px;margin:2px';

        
        // creates a Datagrid
        $this->datagrid = new BootstrapDatagridWrapper(new TDataGrid);
        $this->datagrid->style = 'width: 100%';
        // $this->datagrid->datatable = 'true';
        // $this->datagrid->enablePopover('Popover', 'Hi <b> {name} </b>');
        

        // creates the datagrid columns
        $column_id = new TDataGridColumn('id', 'Id', 'left');
        $column_alt = new TDataGridColumn('alt', 'Nome', 'left');
        $column_link = new TDataGridColumn('link', 'Link', 'left');
        $column_linkimg = new TDataGridColumn('linkimg', 'Url Img', 'left');
        $column_imagem = new TDataGridColumn('imagem', 'Imagem', 'left');
        
        $column_imagem->setTransformer( function($image) { 
            $imagem= new TImage($image); 
            $imagem->style='width:100px';//tamanho da imagem no grid
            return $imagem; 
        }); 


        // add the columns to the DataGrid
        $this->datagrid->addColumn($column_id);            
        $this->datagrid->addColumn($column_alt);
        $this->datagrid->addColumn($column_link);
        $this->datagrid->addColumn($column_linkimg);
        $this->datagrid->addColumn($column_imagem);    

        
        // creates two datagrid actions
        $action1 = new TDataGridAction([$this, 'onEdit']);
        //$action1->setUseButton(TRUE);
        //$action1->setButtonClass('btn btn-default');
        $action1->setLabel(_t('Edit'));
        $action1->setImage('far:edit blue');
        $action1->setField('id');
        
        $action2 = new TDataGridAction([$this, 'onDelete']);
        //$action2->setUseButton(TRUE);
        //$action2->setButtonClass('btn btn-default');
        $action2->setLabel(_t('Delete'));
        $action2->setImage('far:trash-alt red');
        $action2->setField('id');
        
        // add the actions to the datagrid
        $this->datagrid->addAction($action1);
        $this->datagrid->addAction($action2);
        
        // create the datagrid model
        $this->datagrid->createModel();
        
        // creates the page navigation
        $this->pageNavigation = new TPageNavigation;
        $this->pageNavigation->setAction(new TAction([$this, 'onReload']));
        $this->pageNavigation->setWidth($this->datagrid->getWidth());
        
        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        // $container->add(new TXMLBreadCrumb('menu.xml', __CLASS__));
        $container->add($this->form);
        $container->add(TPanelGroup::pack('', $this->datagrid, $this->pageNavigation));
        
        parent::add($container);
    }
        
       
    /**
     * Load the datagrid with data
     */
    public function onReload($param = NULL)
    {
        try
        {
            // open a transaction with database 'imobiliaria'
            TTransaction::open('imobiliaria');
            
            // creates a repository for Banners
            $repository = new TRepository('Banners');
            $limit = 10;
            // creates a criteria
            $criteria = new TCriteria;
            
            // default order
            if (empty($param['order']))
            {
                $param['order'] = 'id';
                $param['direction'] = 'asc';
            }
            $criteria->setProperties($param); // order, offset
            $criteria->setProperty('limit', $limit);
            
            // load the objects according to criteria
            $objects = $repository->load($criteria, FALSE);
            
            $this->datagrid->clear();
            if ($objects)
            {
                // iterate the collection of active records
                foreach ($objects as $object)
                {
                    // add the object inside the datagrid
                    $this->datagrid->addItem($object);
                }
            }
            
            // reset the criteria for record count
            $criteria->resetProperties();
            $count= $repository->count($criteria);
            
            $this->pageNavigation->setCount($count); // count of records
            $this->pageNavigation->setProperties($param); // order, page
            $this->pageNavigation->setLimit($limit); // limit
            
            // close the transaction
            TTransaction::close();
            $this->loaded = true;
        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());
            
            // undo all pending operations
            TTransaction::rollback();
        }
    }
    
    /**
     * Ask before deletion
     */
    public static function onDelete($param)
    {
        // define the delete action
        $action = new TAction([__CLASS__, 'Delete']);
        $action->setParameters($param); // pass the key parameter ahead
        
        // shows a dialog to the user
        new TQuestion(AdiantiCoreTranslator::translate('Do you really want to delete ?'), $action);
    }
    
    /**
     * Delete a record
     */
    public static function Delete($param)
    {
        try
        {
            $key = $param['key']; // get the parameter $key
            TTransaction::open('imobiliaria'); // open a transaction with database
            $object = new Banners($key, FALSE); // instantiates the Active Record
            
            if( file_exists ( $object->imagem))//apaga a  imagem            
            {
               unlink($object->imagem);
            }
            
            $object->delete(); // deletes the object from the database
            TTransaction::close(); // close the transaction
            
            $pos_action = new TAction([__CLASS__, 'onReload']);
            new TMessage('info', AdiantiCoreTranslator::translate('Record deleted'), $pos_action); // success message
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }
    
    /**
     * Save form data
     * @param $param Request
     */
    public function onSave( $param )
    {
        try
        {
            TTransaction::open('imobiliaria'); // open a transaction
            
            /**
            // Enable Debug logger for SQL operations inside the transaction
            TTransaction::setLogger(new TLoggerSTD); // standard output
            TTransaction::setLogger(new TLoggerTXT('log.txt')); // file
            **/
            
            $this->form->validate(); // validate form data
            
            $data = $this->form->getData(); // get form data as array
            
            $object = new Banners;  // create an empty object
            
            $object->fromArray( (array) $data); // load the object with data            
            
            $images = Slim::getImages();            
           
            $object2 = new Banners($data->id); //objeto criado para testar se imagem foi repetida                     
            
            if ($images) {
                         
               $image = $images[0];
               // save output data if set
               if (isset($image['output']['data']))
               {
                  // Save the file
                  $name = $image['output']['name'];
        
                  $ext = pathinfo($name, PATHINFO_EXTENSION);                  
                  $texto = substr($name, 0, -3);
                  $texto = funcoes::name($texto);  
                                                    
                  // We'll use the output crop data                  
                  $datas = $image['output']['data'];    
                   
                  if($datas != null){
                     //salva o arquivo na pasta img/banner com o nome concatenado com o tempo       
                     $output = Slim::saveFile($datas, $texto.'-'.time().'.'.$ext, 'assets/img/banners/', false);

                  } 
                  
                  if( $object2->imagem !=  $output )//se a imagem do banco for diferente da imagem slim
                  {
                     if( file_exists ($object2->imagem))// se existir apaga o anterior
                     {
                        unlink( $object2->imagem ); //apaga
                     }                   
                  }  
                
                  $object->imagem = $output['path'];//recebe o caminho para salvar

               }
            }
            else{
            
               $object->imagem = $object2->imagem;
               
            }
            
            if(empty($object->imagem)) {//primeiro registro
            
                throw new Exception( 'O campo "IMAGEM" é obrigatório'); 
                                    
            }           
            
            $object->store(); // save the object
            
            // get the generated id
            $data->id = $object->id;
            $data->imagem = $object->imagem;
            
            $this->form->setData($data); // fill form data
            TTransaction::close(); // close the transaction
            
            new TMessage('info', AdiantiCoreTranslator::translate('Record saved')); // success message
            $this->onReload(); // reload the listing
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            $this->form->setData( $this->form->getData() ); // keep form data
            TTransaction::rollback(); // undo all pending operations
        }
    }
    
    /**
     * Clear form data
     * @param $param Request
     */
    public function onClear( $param )
    {
        $this->form->clear(TRUE);
    }
    
    /**
     * Load object to form data
     * @param $param Request
     */
    public function onEdit( $param )
    {
        try
        {
            if (isset($param['key']))
            {
                $key = $param['key'];  // get the parameter $key
                TTransaction::open('imobiliaria'); // open a transaction
                $object = new Banners($key); // instantiates the Active Record
                $this->form->setData($object); // fill the form
                TTransaction::close(); // close the transaction
            }
            else
            {
                $this->form->clear(TRUE);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }
    
    /**
     * method show()
     * Shows the page
     */
    public function show()
    {
        // check if the datagrid is already loaded
        if (!$this->loaded AND (!isset($_GET['method']) OR $_GET['method'] !== 'onReload') )
        {
            $this->onReload( func_get_arg(0) );
        }
        parent::show();
    }
}
