<?php 
   
    //Criar as constantes com as credencias de acesso ao banco de dados
   define('__ROOT__', dirname(dirname(__FILE__)));
   setlocale(LC_ALL, 'pt_BR.UTF-8');   
   require_once('vendor/autoload.php');   
   require_once('includes/conexao.php');
   require_once('assets/url.php');
   require_once('vendor/coffeecode/cropper/src/Cropper.php');
   
   $base = URL::getBase();


   
   function url_amigavel($name){
        $filterName = mb_strtolower($name);
            $formats = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜüÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿRr"!@#$%&*()_-+={[}]/?;:.,\\\'<>°ºª~^|`ºª';
            $replace = 'aaaaaaaceeeeiiiidnoooooouuuuuybsaaaaaaaceeeeiiiidnoooooouuuyybyRr                                       ';
            $trimName = trim(strtr(utf8_decode($filterName), utf8_decode($formats), $replace));
            $name = str_replace(["-----", "----", "---", "--"], "-", str_replace(" ", "-", $trimName)); 
            return $name;
    }

    function tiracento($texto){
        $trocarIsso = array('à','á','â','ã','ä','å','ç','è','é','ê','ë','ì','í','î','ï','ñ','ò','ó','ô','õ','ö','ù','ü','ú','ÿ','À','Á','Â','Ã','Ä','Å','Ç','È','É','Ê','Ë','Ì','Í','Î','Ï','Ñ','Ò','Ó','Ô','Õ','Ö','O','Ù','Ü','Ú','Ÿ',);
        $porIsso = array('a','a','a','a','a','a','c','e','e','e','e','i','i','i','i','n','o','o','o','o','o','u','u','u','y','A','A','A','A','A','A','C','E','E','E','E','I','I','I','I','N','O','O','O','O','O','0','U','U','U','Y',);
        $titletext = str_replace($trocarIsso, $porIsso, $texto);
        return $titletext;
   }

	
/*** Função para retornar uma string/Array protegidos contra SQL/Blind/XSS Injection*/
	function protect( &$str ) {
        if( !is_array( $str ) ) { 		    
		    $str = preg_replace( '/(from|select|insert|delete|where|drop|union|order|update|database)/i', '', $str );
            $str = preg_replace( '/(&lt;|<)?script(\/?(&gt;|>(.*))?)/i', '', $str );
            $tbl = get_html_translation_table( HTML_ENTITIES );
            $tbl = array_flip( $tbl );
            $str = addslashes(trim($str));
            $str = strip_tags( $str );
            return strtr( $str, $tbl );
        } 
		else {
            return array_filter( $str, "protect" );
        }
    }
	
$base = URL::getBase(); ///imobiliaria/zoner/
$url0 = Url::getURL(0); //anuncio
$url1 = Url::getURL(1); //venda
$url2 = Url::getURL(2); //codigo
$url3 = Url::getURL(3); //titulo

    
?>
<!DOCTYPE html>

<html lang="pt-br">
<head>
    <meta charset="UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="author" content="Miuller de Faria Castro">
	
    <link  href='http://fonts.googleapis.com/css?family=Roboto:300,400,700' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="<?php echo URL::getBase() ?>assets/fonts/font-awesome.css"  type="text/css">
    <link rel="stylesheet" href="<?php echo URL::getBase() ?>assets/bootstrap/css/bootstrap.css" type="text/css">
    <link rel="stylesheet" href="<?php echo URL::getBase() ?>assets/css/bootstrap-select.min.css" type="text/css">
	<link rel="stylesheet" href="<?php echo URL::getBase() ?>assets/css/magnific-popup.css" type="text/css">
    <link rel="stylesheet" href="<?php echo URL::getBase() ?>assets/css/jquery.slider.min.css" type="text/css">
    <link rel="stylesheet" href="<?php echo URL::getBase() ?>assets/css/owl.carousel.css" type="text/css">
	<link rel="stylesheet" href="<?php echo URL::getBase() ?>assets/css/owl.transitions.css" type="text/css">
	<link rel="stylesheet" href="<?php echo URL::getBase() ?>assets/css/style.css" type="text/css">
    <title></title>

</head>

<body class="page-sub-page page-agencies-listing horizontal-search" id="page-top">
<!-- Wrapper -->
<div class="wrapper">	
	<?php include_once("includes/nav.php"); ?> 	
 <!-- Page Content --> 
     <div id="page-content">	